/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server;

import com.google.common.collect.Lists;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonMapper;
import org.jboss.resteasy.spi.Failure;

@Provider
public class RuntimeExceptionMapper
implements ExceptionMapper<RuntimeException> {
    public Response toResponse(RuntimeException ex) {
        RestfulResponse.HttpStatusCode statusCode = RestfulResponse.HttpStatusCode.INTERNAL_SERVER_ERROR;
        if (ex instanceof Failure) {
            Failure failure = (Failure)ex;
            statusCode = RestfulResponse.HttpStatusCode.statusFor((int)failure.getErrorCode());
        }
        Response.ResponseBuilder builder = Response.status((Response.StatusType)statusCode.getJaxrsStatusType()).type("application/json;profile=urn:org.restfulobjects:repr-types/error").entity((Object)RuntimeExceptionMapper.jsonFor(ex));
        return builder.build();
    }

    static String jsonFor(Exception ex) {
        try {
            return JsonMapper.instance().write((Object)ExceptionPojo.create(ex));
        }
        catch (Exception e) {
            return "{ \"exception\": \"" + ExceptionUtils.getFullStackTrace((Throwable)ex) + "\" }";
        }
    }

    private static class ExceptionPojo {
        private final String message;
        private final List<String> stackTrace = Lists.newArrayList();
        private ExceptionPojo causedBy;

        public static ExceptionPojo create(Exception ex) {
            return new ExceptionPojo(ex);
        }

        private static String format(StackTraceElement stackTraceElement) {
            return stackTraceElement.toString();
        }

        public ExceptionPojo(Throwable ex) {
            StackTraceElement[] stackTraceElements;
            this.message = ExceptionPojo.messageFor(ex);
            for (StackTraceElement stackTraceElement : stackTraceElements = ex.getStackTrace()) {
                this.stackTrace.add(ExceptionPojo.format(stackTraceElement));
            }
            Throwable cause = ex.getCause();
            if (cause != null && cause != ex) {
                this.causedBy = new ExceptionPojo(cause);
            }
        }

        private static String messageFor(Throwable ex) {
            String message = ex.getMessage();
            return message != null ? message : ex.getClass().getName();
        }

        public String getMessage() {
            return this.message;
        }

        public List<String> getStackTrace() {
            return this.stackTrace;
        }

        public ExceptionPojo getCausedBy() {
            return this.causedBy;
        }
    }
}

