/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server;

import com.google.common.collect.Lists;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonMapper;
import org.apache.isis.viewer.restfulobjects.server.HasHttpStatusCode;
import org.apache.isis.viewer.restfulobjects.server.RestfulObjectsApplicationException;

@Provider
public class RestfulObjectsApplicationExceptionMapper
implements ExceptionMapper<RestfulObjectsApplicationException> {
    public Response toResponse(RestfulObjectsApplicationException ex) {
        String body;
        Response.ResponseBuilder builder = Response.status((Response.StatusType)ex.getHttpStatusCode().getJaxrsStatusType());
        JsonRepresentation bodyRepr = ex.getBody();
        Throwable cause = ex.getCause();
        if (bodyRepr != null) {
            body = bodyRepr.toString();
            builder.entity((Object)body);
            builder.type("application/json");
        } else if (cause == null) {
            builder.type("application/json");
        } else {
            try {
                body = JsonMapper.instance().write((Object)ExceptionPojo.create(cause));
            }
            catch (Exception e) {
                body = "{ \"exception\": \"" + ExceptionUtils.getFullStackTrace((Throwable)cause) + "\" }";
            }
            builder.entity((Object)body);
            builder.type("application/json;profile=urn:org.restfulobjects:repr-types/error");
        }
        String message = ex.getMessage();
        if (message != null) {
            builder.header(RestfulResponse.Header.WARNING.getName(), (Object)RestfulResponse.Header.WARNING.render((Object)message));
        }
        return builder.build();
    }

    private static class ExceptionPojo {
        private final int httpStatusCode;
        private final String message;
        private final List<String> stackTrace = Lists.newArrayList();
        private ExceptionPojo causedBy;

        public static ExceptionPojo create(Throwable ex) {
            return new ExceptionPojo(ex);
        }

        private static String format(StackTraceElement stackTraceElement) {
            return stackTraceElement.toString();
        }

        public ExceptionPojo(Throwable ex) {
            StackTraceElement[] stackTraceElements;
            this.httpStatusCode = this.getHttpStatusCodeIfAny(ex);
            this.message = ex.getMessage();
            for (StackTraceElement stackTraceElement : stackTraceElements = ex.getStackTrace()) {
                this.stackTrace.add(ExceptionPojo.format(stackTraceElement));
            }
            Throwable cause = ex.getCause();
            if (cause != null && cause != ex) {
                this.causedBy = new ExceptionPojo(cause);
            }
        }

        private int getHttpStatusCodeIfAny(Throwable ex) {
            if (!(ex instanceof HasHttpStatusCode)) {
                return 0;
            }
            HasHttpStatusCode hasHttpStatusCode = (HasHttpStatusCode)((Object)ex);
            return hasHttpStatusCode.getHttpStatusCode().getStatusCode();
        }

        public int getHttpStatusCode() {
            return this.httpStatusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public List<String> getStackTrace() {
            return this.stackTrace;
        }

        public ExceptionPojo getCausedBy() {
            return this.causedBy;
        }
    }
}

