/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulRequest;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.server.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.server.resources.DomainResourceHelper;

public class ResourceContext
implements RendererContext {
    private final HttpHeaders httpHeaders;
    private final UriInfo uriInfo;
    private final Request request;
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;
    private final SecurityContext securityContext;
    private final Localization localization;
    private final IsisConfiguration configuration;
    private final AuthenticationSession authenticationSession;
    private final PersistenceSession persistenceSession;
    private final AdapterManager adapterManager;
    private final SpecificationLoader specificationLookup;
    private List<List<String>> followLinks;
    private final Where where;
    private final String queryString;
    private JsonRepresentation readQueryStringAsMap;

    public ResourceContext(RepresentationType representationType, HttpHeaders httpHeaders, UriInfo uriInfo, Request request, Where where, String queryStringIfAny, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SecurityContext securityContext, Localization localization, AuthenticationSession authenticationSession, PersistenceSession persistenceSession, AdapterManager objectAdapterLookup, SpecificationLoader specificationLookup, IsisConfiguration configuration) {
        this.httpHeaders = httpHeaders;
        this.uriInfo = uriInfo;
        this.request = request;
        this.queryString = queryStringIfAny;
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
        this.securityContext = securityContext;
        this.localization = localization;
        this.configuration = configuration;
        this.authenticationSession = authenticationSession;
        this.persistenceSession = persistenceSession;
        this.adapterManager = objectAdapterLookup;
        this.specificationLookup = specificationLookup;
        this.where = where;
        this.init(representationType);
    }

    void init(RepresentationType representationType) {
        this.getQueryStringAsJsonRepr();
        this.ensureCompatibleAcceptHeader(representationType);
        this.ensureDomainModelQueryParamSupported();
        this.followLinks = Collections.unmodifiableList((List)this.getArg(RestfulRequest.RequestParameter.FOLLOW_LINKS));
    }

    private void ensureDomainModelQueryParamSupported() {
        RestfulRequest.DomainModel domainModel = (RestfulRequest.DomainModel)this.getArg(RestfulRequest.RequestParameter.DOMAIN_MODEL);
        if (domainModel != RestfulRequest.DomainModel.FORMAL) {
            throw RestfulObjectsApplicationException.createWithMessage(RestfulResponse.HttpStatusCode.BAD_REQUEST, "x-ro-domain-model of '%s' is not supported", domainModel);
        }
    }

    private void ensureCompatibleAcceptHeader(RepresentationType representationType) {
        if (representationType == null) {
            return;
        }
        String producedProfile = representationType.getMediaTypeProfile();
        if (producedProfile != null) {
            for (MediaType mediaType : this.httpHeaders.getAcceptableMediaTypes()) {
                String acceptedProfileValue = (String)mediaType.getParameters().get("profile");
                if (acceptedProfileValue == null || producedProfile.equals(acceptedProfileValue)) continue;
                throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_ACCEPTABLE);
            }
        }
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getQueryString() {
        if (this.queryString != null) {
            return this.queryString;
        }
        return this.getHttpServletRequest().getQueryString();
    }

    public JsonRepresentation getQueryStringAsJsonRepr() {
        if (this.readQueryStringAsMap == null) {
            this.readQueryStringAsMap = this.requestArgsAsMap();
        }
        return this.readQueryStringAsMap;
    }

    protected JsonRepresentation requestArgsAsMap() {
        Map params = this.httpServletRequest.getParameterMap();
        if (ResourceContext.simpleQueryArgs(params)) {
            JsonRepresentation map = JsonRepresentation.newMap((String[])new String[0]);
            for (String paramName : params.keySet()) {
                String paramValue = ((String[])params.get(paramName))[0];
                try {
                    int paramValueAsInt = Integer.parseInt(paramValue);
                    map.mapPut(paramName + ".value", paramValueAsInt);
                }
                catch (Exception ex) {
                    map.mapPut(paramName + ".value", paramValue);
                }
            }
            return map;
        }
        return DomainResourceHelper.readQueryStringAsMap(this.getQueryString());
    }

    private static boolean simpleQueryArgs(Map<String, String[]> params) {
        if (params.isEmpty()) {
            return false;
        }
        for (String paramName : params.keySet()) {
            if (!"x-isis-querystring".equals(paramName) && !paramName.startsWith("{")) continue;
            return false;
        }
        return true;
    }

    public <Q> Q getArg(RestfulRequest.RequestParameter<Q> requestParameter) {
        JsonRepresentation queryStringJsonRepr = this.getQueryStringAsJsonRepr();
        return (Q)requestParameter.valueOf(queryStringJsonRepr);
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public Request getRequest() {
        return this.request;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.httpServletResponse;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public List<List<String>> getFollowLinks() {
        return this.followLinks;
    }

    public Localization getLocalization() {
        return this.localization;
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    public PersistenceSession getPersistenceSession() {
        return this.persistenceSession;
    }

    public List<ObjectAdapter> getServiceAdapters() {
        return this.persistenceSession.getServices();
    }

    public SpecificationLoader getSpecificationLookup() {
        return this.specificationLookup;
    }

    public Where getWhere() {
        return this.where;
    }

    public String urlFor(String url) {
        return this.getUriInfo().getBaseUri().toString() + url;
    }
}

