/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.util;

import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.server.util.UrlParserUtils;
import org.junit.Assert;
import org.junit.Test;

public class UrlParserUtilsTest {
    @Test
    public void oidFromLink() throws Exception {
        JsonRepresentation link = JsonRepresentation.newMap((String[])new String[0]);
        link.mapPut("href", "http://localhost/objects/OID/1");
        String oidFromHref = UrlParserUtils.encodedOidFromLink((JsonRepresentation)link);
        Assert.assertEquals((Object)"OID:1", (Object)oidFromHref);
    }

    @Test
    public void domainTypeFromLink() throws Exception {
        JsonRepresentation link = JsonRepresentation.newMap((String[])new String[0]);
        link.mapPut("href", "http://localhost/domain-types/com.mycompany.myapp.Customer");
        String oidFromHref = UrlParserUtils.domainTypeFrom((JsonRepresentation)link);
        Assert.assertEquals((Object)"com.mycompany.myapp.Customer", (Object)oidFromHref);
    }

    @Test
    public void domainTypeFromLinkTrailingSlash() throws Exception {
        JsonRepresentation link = JsonRepresentation.newMap((String[])new String[0]);
        link.mapPut("href", "http://localhost/domain-types/com.mycompany.myapp.Customer/");
        String oidFromHref = UrlParserUtils.domainTypeFrom((JsonRepresentation)link);
        Assert.assertEquals((Object)"com.mycompany.myapp.Customer", (Object)oidFromHref);
    }

    @Test
    public void domainTypeFromLinkFollowingStuff() throws Exception {
        JsonRepresentation link = JsonRepresentation.newMap((String[])new String[0]);
        link.mapPut("href", "http://localhost/domain-types/com.mycompany.myapp.Customer/otherStuffHere");
        String oidFromHref = UrlParserUtils.domainTypeFrom((JsonRepresentation)link);
        Assert.assertEquals((Object)"com.mycompany.myapp.Customer", (Object)oidFromHref);
    }
}

