/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.resources;

import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.server.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.server.resources.DomainResourceHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DomainResourceHelperTest_readBodyAsMap {
    private JsonRepresentation representation;

    @Test
    public void whenNull() throws Exception {
        this.representation = DomainResourceHelper.readAsMap(null);
        Assert.assertThat((Object)this.representation.isMap(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.representation.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void whenEmptyString() throws Exception {
        this.representation = DomainResourceHelper.readAsMap((String)"");
        Assert.assertThat((Object)this.representation.isMap(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.representation.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void whenWhitespaceOnlyString() throws Exception {
        this.representation = DomainResourceHelper.readAsMap((String)" \t ");
        Assert.assertThat((Object)this.representation.isMap(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.representation.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void emptyMap() throws Exception {
        this.representation = DomainResourceHelper.readAsMap((String)"{}");
        Assert.assertThat((Object)this.representation.isMap(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.representation.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void map() throws Exception {
        this.representation = DomainResourceHelper.readAsMap((String)"{\"foo\":\"bar\"}");
        Assert.assertThat((Object)this.representation.isMap(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.representation.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test(expected=RestfulObjectsApplicationException.class)
    public void whenArray() throws Exception {
        DomainResourceHelper.readAsMap((String)"[]");
    }
}

