/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server;

import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonMapper;
import org.apache.isis.viewer.restfulobjects.server.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.server.RestfulObjectsApplicationExceptionMapper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RestfulObjectsApplicationExceptionMapperTest {
    private RestfulObjectsApplicationExceptionMapper exceptionMapper;

    @Before
    public void setUp() throws Exception {
        this.exceptionMapper = new RestfulObjectsApplicationExceptionMapper();
    }

    @Test
    public void simpleNoMessage() throws Exception {
        RestfulResponse.HttpStatusCode status = RestfulResponse.HttpStatusCode.BAD_REQUEST;
        RestfulObjectsApplicationException ex = RestfulObjectsApplicationException.create((RestfulResponse.HttpStatusCode)status);
        Response response = this.exceptionMapper.toResponse(ex);
        Assert.assertThat((Object)RestfulResponse.HttpStatusCode.lookup((int)response.getStatus()), (Matcher)CoreMatchers.is((Object)status));
        Assert.assertThat((Object)response.getMetadata().get((Object)"Warning"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        String entity = (String)response.getEntity();
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void entity_withMessage() throws Exception {
        RestfulObjectsApplicationException ex = RestfulObjectsApplicationException.createWithMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (String)"foobar", (Object[])new Object[0]);
        Response response = this.exceptionMapper.toResponse(ex);
        Assert.assertThat((Object)((String)((List)response.getMetadata().get((Object)"Warning")).get(0)), (Matcher)CoreMatchers.is((Object)("199 RestfulObjects " + ex.getMessage())));
        String entity = (String)response.getEntity();
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void entity_forException() throws Exception {
        Exception exception = new Exception("barfoo");
        RestfulObjectsApplicationException ex = RestfulObjectsApplicationException.createWithCauseAndMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (Exception)exception, (String)"foobar", (Object[])new Object[0]);
        Response response = this.exceptionMapper.toResponse(ex);
        String entity = (String)response.getEntity();
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        JsonRepresentation jsonRepr = (JsonRepresentation)JsonMapper.instance().read(entity, JsonRepresentation.class);
        Assert.assertThat((Object)((String)((List)response.getMetadata().get((Object)"Warning")).get(0)), (Matcher)CoreMatchers.is((Object)"199 RestfulObjects foobar"));
        Assert.assertThat((Object)jsonRepr.getString("message"), (Matcher)CoreMatchers.is((Object)"barfoo"));
        JsonRepresentation causedByRepr = jsonRepr.getRepresentation("causedBy", new Object[0]);
        Assert.assertThat((Object)causedByRepr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void entity_forExceptionWithCause() throws Exception {
        Exception cause = new Exception("bozfoz");
        Exception exception = new Exception("barfoo", cause);
        RestfulObjectsApplicationException ex = RestfulObjectsApplicationException.createWithCauseAndMessage((RestfulResponse.HttpStatusCode)RestfulResponse.HttpStatusCode.BAD_REQUEST, (Exception)exception, (String)"foobar", (Object[])new Object[0]);
        Response response = this.exceptionMapper.toResponse(ex);
        String entity = (String)response.getEntity();
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        JsonRepresentation jsonRepr = (JsonRepresentation)JsonMapper.instance().read(entity, JsonRepresentation.class);
        Assert.assertThat((Object)((String)((List)response.getMetadata().get((Object)"Warning")).get(0)), (Matcher)CoreMatchers.is((Object)"199 RestfulObjects foobar"));
        Assert.assertThat((Object)jsonRepr.getString("message"), (Matcher)CoreMatchers.is((Object)"barfoo"));
        JsonRepresentation causedByRepr = jsonRepr.getRepresentation("causedBy", new Object[0]);
        Assert.assertThat((Object)causedByRepr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)causedByRepr.getString("message"), (Matcher)CoreMatchers.is((Object)cause.getMessage()));
    }
}

