/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server;

import javax.servlet.http.HttpServletRequest;
import org.apache.isis.core.unittestsupport.jmocking.JUnitRuleMockery2;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulRequest;
import org.apache.isis.viewer.restfulobjects.applib.util.UrlEncodingUtils;
import org.apache.isis.viewer.restfulobjects.server.ResourceContext;
import org.codehaus.jackson.JsonNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.auto.Mock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ResourceContextTest_getArg {
    @Rule
    public JUnitRuleMockery2 context = JUnitRuleMockery2.createFor((JUnitRuleMockery2.Mode)JUnitRuleMockery2.Mode.INTERFACES_AND_CLASSES);
    @Mock
    private HttpServletRequest httpServletRequest;
    @Mock
    private ResourceContext resourceContext;
    private String queryString;

    @Test
    public void whenArgExists() throws Exception {
        this.queryString = UrlEncodingUtils.urlEncode((JsonNode)JsonRepresentation.newMap((String[])new String[]{"x-ro-page", "123"}).asJsonNode());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(ResourceContextTest_getArg.this.httpServletRequest)).getQueryString();
                this.will(1.returnValue((Object)ResourceContextTest_getArg.this.queryString));
            }
        });
        this.resourceContext = new ResourceContext(null, null, null, null, null, null, this.httpServletRequest, null, null, null, null, null, null, null, null){

            void init(RepresentationType representationType) {
            }
        };
        Integer arg = (Integer)this.resourceContext.getArg(RestfulRequest.RequestParameter.PAGE);
        Assert.assertThat((Object)arg, (Matcher)CoreMatchers.equalTo((Object)123));
    }

    @Test
    public void whenArgDoesNotExist() throws Exception {
        this.queryString = UrlEncodingUtils.urlEncode((JsonNode)JsonRepresentation.newMap((String[])new String[]{"xxx", "123"}).asJsonNode());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(ResourceContextTest_getArg.this.httpServletRequest)).getQueryString();
                this.will(3.returnValue((Object)ResourceContextTest_getArg.this.queryString));
            }
        });
        this.resourceContext = new ResourceContext(null, null, null, null, null, null, this.httpServletRequest, null, null, null, null, null, null, null, null){

            void init(RepresentationType representationType) {
            }
        };
        Integer arg = (Integer)this.resourceContext.getArg(RestfulRequest.RequestParameter.PAGE);
        Assert.assertThat((Object)arg, (Matcher)CoreMatchers.equalTo((Object)RestfulRequest.RequestParameter.PAGE.getDefault()));
    }
}

