/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.server.ResourceContext;
import org.apache.isis.viewer.restfulobjects.server.RestfulObjectsApplicationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceContextTest_ensureCompatibleAcceptHeader {
    private HttpHeaders httpHeaders;
    private HttpServletRequest httpServletRequest;
    private final Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.httpHeaders = (HttpHeaders)this.context.mock(HttpHeaders.class);
        this.httpServletRequest = (HttpServletRequest)this.context.mock(HttpServletRequest.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.allowing(ResourceContextTest_ensureCompatibleAcceptHeader.this.httpServletRequest)).getQueryString();
                this.will(1.returnValue((Object)""));
            }
        });
    }

    @Test
    public void noop() throws Exception {
        RepresentationType representationType = RepresentationType.HOME_PAGE;
        this.givenHttpHeadersGetAcceptableMediaTypesReturns(Arrays.asList(representationType.getMediaType()));
        this.instantiateResourceContext(representationType);
    }

    @Test
    public void happyCase() throws Exception {
        RepresentationType representationType = RepresentationType.HOME_PAGE;
        this.givenHttpHeadersGetAcceptableMediaTypesReturns(Arrays.asList(representationType.getMediaType()));
        this.instantiateResourceContext(representationType);
    }

    @Test
    public void acceptGenericAndProduceGeneric() throws Exception {
        RepresentationType representationType = RepresentationType.GENERIC;
        this.givenHttpHeadersGetAcceptableMediaTypesReturns(Arrays.asList(MediaType.APPLICATION_JSON_TYPE));
        this.instantiateResourceContext(representationType);
    }

    @Test
    public void acceptGenericAndProduceSpecific() throws Exception {
        RepresentationType representationType = RepresentationType.HOME_PAGE;
        this.givenHttpHeadersGetAcceptableMediaTypesReturns(Arrays.asList(MediaType.APPLICATION_JSON_TYPE));
        this.instantiateResourceContext(representationType);
    }

    @Test
    public void nonMatching() throws Exception {
        RepresentationType representationType = RepresentationType.HOME_PAGE;
        this.givenHttpHeadersGetAcceptableMediaTypesReturns(Arrays.asList(MediaType.APPLICATION_ATOM_XML_TYPE));
        try {
            this.instantiateResourceContext(representationType);
        }
        catch (RestfulObjectsApplicationException ex) {
            Assert.assertThat((Object)ex.getHttpStatusCode(), (Matcher)CoreMatchers.is((Object)RestfulResponse.HttpStatusCode.NOT_ACCEPTABLE));
        }
    }

    @Test
    public void nonMatchingProfile() throws Exception {
        RepresentationType representationType = RepresentationType.HOME_PAGE;
        this.givenHttpHeadersGetAcceptableMediaTypesReturns(Arrays.asList(RepresentationType.USER.getMediaType()));
        try {
            this.instantiateResourceContext(representationType);
        }
        catch (RestfulObjectsApplicationException ex) {
            Assert.assertThat((Object)ex.getHttpStatusCode(), (Matcher)CoreMatchers.is((Object)RestfulResponse.HttpStatusCode.NOT_ACCEPTABLE));
        }
    }

    @Test
    public void nonMatchingProfile_ignoreGeneric() throws Exception {
        RepresentationType representationType = RepresentationType.HOME_PAGE;
        this.givenHttpHeadersGetAcceptableMediaTypesReturns(Arrays.asList(RepresentationType.USER.getMediaType(), MediaType.APPLICATION_JSON_TYPE));
        try {
            this.instantiateResourceContext(representationType);
        }
        catch (RestfulObjectsApplicationException ex) {
            Assert.assertThat((Object)ex.getHttpStatusCode(), (Matcher)CoreMatchers.is((Object)RestfulResponse.HttpStatusCode.NOT_ACCEPTABLE));
        }
    }

    @Test
    public void emptyList_isOK() throws Exception {
        RepresentationType representationType = RepresentationType.HOME_PAGE;
        this.givenHttpHeadersGetAcceptableMediaTypesReturns(Arrays.asList(new MediaType[0]));
        this.instantiateResourceContext(representationType);
    }

    private void givenHttpHeadersGetAcceptableMediaTypesReturns(final List<MediaType> mediaTypes) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpHeaders)this.one(ResourceContextTest_ensureCompatibleAcceptHeader.this.httpHeaders)).getAcceptableMediaTypes();
                this.will(2.returnValue((Object)mediaTypes));
            }
        });
    }

    private ResourceContext instantiateResourceContext(RepresentationType representationType) {
        return new ResourceContext(representationType, this.httpHeaders, null, null, null, (String)null, this.httpServletRequest, null, null, null, null, null, null, null, null);
    }
}

