/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal.Tagger;
import org.springframework.stereotype.Component;

@Component
@Named(value="isisMetaModel.TaggerDefault")
public class TaggerDefault
implements Tagger {
    static Pattern tagSpringFramework = Pattern.compile("^org\\.springframework\\.([^\\.]+)\\.(.+)$");
    static Pattern tagPatternIsisExtensions2 = Pattern.compile("^isisExt(.+)$");
    static Pattern tagPatternIsisExtensions = Pattern.compile("^org\\.apache\\.isis\\.extensions\\.([^\\.]+)\\.(.+)$");
    static Pattern tagPatternForFqcn = Pattern.compile("^.*\\.([^\\.]+)\\.([^\\.]+)$");
    static Pattern tagPatternForTwoParts = Pattern.compile("^([^\\.]+)\\.([^\\.]+)$");
    static Pattern tagPatternForJaxbDto = Pattern.compile("^.*\\.([^\\.]+)\\.(v[0-9][^\\.]*)\\.([^\\.]+)$");

    @Override
    @Programmatic
    public String tagForObjectType(String objType, String fallback) {
        if (objType.startsWith("org.apache.isis.")) {
            return ". apache isis internals";
        }
        Matcher matcher = tagSpringFramework.matcher(objType);
        if (matcher.matches()) {
            return "> spring framework " + matcher.group(1);
        }
        matcher = tagPatternIsisExtensions.matcher(objType);
        if (matcher.matches()) {
            return ". apache isis extensions - " + matcher.group(1);
        }
        matcher = tagPatternForJaxbDto.matcher(objType);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = tagPatternForFqcn.matcher(objType);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = tagPatternForTwoParts.matcher(objType);
        if (matcher.matches()) {
            if (objType.startsWith("isisApplib")) {
                return ". apache isis applib";
            }
            if (objType.startsWith("isisExt")) {
                return ". apache isis extensions - " + matcher.group(1);
            }
            return matcher.group(1);
        }
        return fallback != null ? fallback : objType;
    }
}

