/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal.ClassExcluder;
import org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal.Generation;
import org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal.Tagger;
import org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal.ValuePropertyFactory;
import org.springframework.stereotype.Component;

@Component
@Named(value="isisMetaModel.SwaggerSpecGenerator")
public class SwaggerSpecGenerator {
    private final SpecificationLoader specificationLoader;
    private final Tagger tagger;
    private final ClassExcluder classExcluder;
    private final ValuePropertyFactory valuePropertyFactory;

    @Inject
    public SwaggerSpecGenerator(SpecificationLoader specificationLoader, Tagger tagger, ClassExcluder classExcluder, ValuePropertyFactory valuePropertyFactory) {
        this.specificationLoader = specificationLoader;
        this.tagger = tagger;
        this.classExcluder = classExcluder;
        this.valuePropertyFactory = valuePropertyFactory;
    }

    public String generate(String basePath, SwaggerService.Visibility visibility, SwaggerService.Format format) {
        Generation generation = this.newGeneration(basePath, visibility);
        Swagger swagger = generation.generate();
        switch (format) {
            case JSON: {
                return Json.pretty((Object)swagger);
            }
            case YAML: {
                try {
                    return Yaml.pretty().writeValueAsString((Object)swagger);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new IllegalArgumentException("Unrecognized format: " + format);
    }

    protected Generation newGeneration(String basePath, SwaggerService.Visibility visibility) {
        return new Generation(basePath, visibility, this.specificationLoader, this.tagger, this.classExcluder, this.valuePropertyFactory);
    }
}

