/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.swagger;

import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.LocalResourcePath;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.config.RestEasyConfiguration;

@Named(value="isisApplib.SwaggerServiceMenu")
@DomainService(objectType="isisApplib.SwaggerServiceMenu")
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
public class SwaggerServiceMenu {
    private final SwaggerService swaggerService;
    private final ServiceRegistry serviceRegistry;
    private final RestEasyConfiguration restEasyConfiguration;
    private final String basePath;

    @Inject
    public SwaggerServiceMenu(SwaggerService swaggerService, ServiceRegistry serviceRegistry, RestEasyConfiguration restEasyConfiguration) {
        this.swaggerService = swaggerService;
        this.serviceRegistry = serviceRegistry;
        this.restEasyConfiguration = restEasyConfiguration;
        this.basePath = this.restEasyConfiguration.getJaxrs().getDefaultPath() + "/";
    }

    @Action(semantics=SemanticsOf.SAFE, domainEvent=OpenSwaggerUiDomainEvent.class, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-external-link-alt")
    @MemberOrder(sequence="500.600.1")
    public LocalResourcePath openSwaggerUi() {
        return new LocalResourcePath("/swagger-ui/index.thtml");
    }

    public String disableOpenSwaggerUi() {
        return this.disableReasonWhenRequiresROViewer();
    }

    @Action(semantics=SemanticsOf.SAFE, domainEvent=OpenSwaggerUiDomainEvent.class, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-external-link-alt")
    @MemberOrder(sequence="500.600.2")
    public LocalResourcePath openRestApi() {
        return new LocalResourcePath(this.basePath);
    }

    public String disableOpenRestApi() {
        return this.disableReasonWhenRequiresROViewer();
    }

    @Action(semantics=SemanticsOf.SAFE, domainEvent=DownloadSwaggerSpecDomainEvent.class, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download")
    @MemberOrder(sequence="500.600.3")
    public Clob downloadSwaggerSchemaDefinition(@ParameterLayout(named="Filename") String fileNamePrefix, SwaggerService.Visibility visibility, SwaggerService.Format format) {
        String fileName = SwaggerServiceMenu.buildFileName(fileNamePrefix, visibility, format);
        String spec = this.swaggerService.generateSwaggerSpec(visibility, format);
        return new Clob(fileName, format.mediaType(), (CharSequence)spec);
    }

    public String default0DownloadSwaggerSchemaDefinition() {
        return "swagger";
    }

    public SwaggerService.Visibility default1DownloadSwaggerSchemaDefinition() {
        return SwaggerService.Visibility.PRIVATE;
    }

    public SwaggerService.Format default2DownloadSwaggerSchemaDefinition() {
        return SwaggerService.Format.YAML;
    }

    private String disableReasonWhenRequiresROViewer() {
        Optional moduleIfAny = this.serviceRegistry.lookupBeanById("isisRoViewer.WebModuleJaxrsRestEasy4");
        return moduleIfAny.isPresent() ? null : "RestfulObjects viewer is not configured";
    }

    private static String buildFileName(String fileNamePrefix, SwaggerService.Visibility visibility, SwaggerService.Format format) {
        String formatLower = format.name().toLowerCase();
        int i = fileNamePrefix.lastIndexOf("." + formatLower);
        if (i > 0) {
            fileNamePrefix = fileNamePrefix.substring(0, i);
        }
        return _Strings.asFileNameWithExtension((String)(fileNamePrefix + "-" + visibility.name().toLowerCase()), (String)formatLower);
    }

    public static class DownloadSwaggerSpecDomainEvent
    extends ActionDomainEvent {
    }

    public static class OpenRestApiDomainEvent
    extends ActionDomainEvent {
    }

    public static class OpenSwaggerUiDomainEvent
    extends ActionDomainEvent {
    }

    public static abstract class ActionDomainEvent
    extends IsisModuleApplib.ActionDomainEvent<SwaggerServiceMenu> {
    }
}

