/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.swagger;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.config.RestEasyConfiguration;
import org.apache.isis.core.config.viewer.wicket.WebAppContextPath;
import org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal.SwaggerSpecGenerator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isisMetaModel.swaggerServiceDefault")
@Order(value=0)
@Primary
@Qualifier(value="Default")
public class SwaggerServiceDefault
implements SwaggerService {
    private final SwaggerSpecGenerator swaggerSpecGenerator;
    private final String basePath;

    @Inject
    public SwaggerServiceDefault(SwaggerSpecGenerator swaggerSpecGenerator, RestEasyConfiguration restEasyConfiguration, WebAppContextPath webAppContextPath) {
        this.swaggerSpecGenerator = swaggerSpecGenerator;
        String restfulPath = restEasyConfiguration.getJaxrs().getDefaultPath();
        String restfulBase = webAppContextPath.prependContextPath(restfulPath);
        this.basePath = _Strings.suffix((String)restfulBase, (String)"/");
    }

    public String generateSwaggerSpec(SwaggerService.Visibility visibility, SwaggerService.Format format) {
        return this.swaggerSpecGenerator.generate(this.basePath, visibility, format);
    }
}

