/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.conneg;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.client.SuppressionType;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.collections.CollectionFacet;
import org.apache.isis.core.metamodel.interactions.managed.ManagedAction;
import org.apache.isis.core.metamodel.interactions.managed.ManagedCollection;
import org.apache.isis.core.metamodel.interactions.managed.ManagedMember;
import org.apache.isis.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectPropertyReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationServiceAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationServiceForRestfulObjectsV1_0;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isisRoRendering.ContentNegotiationServiceOrgApacheIsisV1")
@Order(value=-200)
@Qualifier(value="OrgApacheIsisV1")
public class ContentNegotiationServiceOrgApacheIsisV1
extends ContentNegotiationServiceAbstract {
    public static final String ACCEPT_PROFILE = "urn:org.apache.isis/v1";
    public static final String CONTENT_TYPE_OAI_V1_OBJECT = "application/json;profile=\"urn:org.apache.isis/v1\";repr-type=\"object\"";
    public static final String CONTENT_TYPE_OAI_V1_OBJECT_COLLECTION = "application/json;profile=\"urn:org.apache.isis/v1\";repr-type=\"object-collection\"";
    public static final String CONTENT_TYPE_OAI_V1_LIST = "application/json;profile=\"urn:org.apache.isis/v1\";repr-type=\"list\"";
    private final ContentNegotiationServiceForRestfulObjectsV1_0 restfulObjectsV1_0;

    public ContentNegotiationServiceOrgApacheIsisV1(ContentNegotiationServiceForRestfulObjectsV1_0 restfulObjectsV1_0) {
        this.restfulObjectsV1_0 = restfulObjectsV1_0;
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedObject objectAdapter) {
        JsonRepresentation $$roRepresentation;
        boolean canAccept = this.canAccept(resourceContext);
        if (!canAccept) {
            return null;
        }
        EnumSet<SuppressionType> suppression = this.suppress(resourceContext);
        boolean suppressRO = suppression.contains(SuppressionType.RO);
        JsonRepresentation rootRepresentation = JsonRepresentation.newMap((String[])new String[0]);
        this.appendObjectTo(resourceContext, objectAdapter, rootRepresentation, suppression);
        if (!suppressRO) {
            $$roRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            rootRepresentation.mapPut("$$ro", $$roRepresentation);
        } else {
            $$roRepresentation = null;
        }
        Response.ResponseBuilder responseBuilder = this.restfulObjectsV1_0.buildResponseTo(resourceContext, objectAdapter, $$roRepresentation, rootRepresentation);
        responseBuilder.type(CONTENT_TYPE_OAI_V1_OBJECT);
        return this.responseBuilder(responseBuilder);
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedProperty objectAndProperty) {
        return null;
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedCollection managedCollection) {
        JsonRepresentation $$roRepresentation;
        if (!this.canAccept(resourceContext)) {
            return null;
        }
        EnumSet<SuppressionType> suppression = this.suppress(resourceContext);
        boolean suppressRO = suppression.contains(SuppressionType.RO);
        JsonRepresentation rootRepresentation = JsonRepresentation.newArray();
        this.appendCollectionTo(resourceContext, managedCollection, rootRepresentation, suppression);
        if (!suppressRO) {
            JsonRepresentation $$roContainerRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            rootRepresentation.arrayAdd($$roContainerRepresentation);
            $$roRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            $$roContainerRepresentation.mapPut("$$ro", $$roRepresentation);
        } else {
            $$roRepresentation = null;
        }
        Response.ResponseBuilder responseBuilder = this.restfulObjectsV1_0.buildResponseTo(resourceContext, managedCollection, $$roRepresentation, rootRepresentation);
        responseBuilder.type(CONTENT_TYPE_OAI_V1_OBJECT_COLLECTION);
        return this.responseBuilder(responseBuilder);
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ManagedAction objectAndAction) {
        return null;
    }

    @Override
    public Response.ResponseBuilder buildResponse(IResourceContext resourceContext, ObjectAndActionInvocation objectAndActionInvocation) {
        JsonRepresentation rootRepresentation;
        if (!this.canAccept(resourceContext)) {
            return null;
        }
        EnumSet<SuppressionType> suppression = this.suppress(resourceContext);
        boolean suppressRO = suppression.contains(SuppressionType.RO);
        JsonRepresentation $$roRepresentation = !suppressRO ? JsonRepresentation.newMap((String[])new String[0]) : null;
        ManagedObject returnedAdapter = objectAndActionInvocation.getReturnedAdapter();
        if (returnedAdapter == null) {
            return null;
        }
        ActionResultRepresentation.ResultType resultType = objectAndActionInvocation.determineResultType();
        switch (resultType) {
            case DOMAIN_OBJECT: {
                rootRepresentation = JsonRepresentation.newMap((String[])new String[0]);
                this.appendObjectTo(resourceContext, returnedAdapter, rootRepresentation, suppression);
                break;
            }
            case LIST: {
                rootRepresentation = JsonRepresentation.newArray();
                CollectionFacet.streamAdapters((ManagedObject)returnedAdapter).forEach(element -> this.appendElementTo(resourceContext, (ManagedObject)element, rootRepresentation, suppression));
                if (suppressRO) break;
                JsonRepresentation $$roContainerRepresentation = JsonRepresentation.newMap((String[])new String[0]);
                rootRepresentation.arrayAdd($$roContainerRepresentation);
                $$roContainerRepresentation.mapPut("$$ro", $$roRepresentation);
                break;
            }
            case SCALAR_VALUE: 
            case VOID: {
                return null;
            }
            default: {
                rootRepresentation = null;
            }
        }
        Response.ResponseBuilder responseBuilder = this.restfulObjectsV1_0.buildResponseTo(resourceContext, objectAndActionInvocation, $$roRepresentation, rootRepresentation);
        responseBuilder.type(resultType == ActionResultRepresentation.ResultType.DOMAIN_OBJECT ? CONTENT_TYPE_OAI_V1_OBJECT : CONTENT_TYPE_OAI_V1_LIST);
        return this.responseBuilder(responseBuilder);
    }

    protected Response.ResponseBuilder responseBuilder(Response.ResponseBuilder responseBuilder) {
        return responseBuilder;
    }

    boolean canAccept(IResourceContext resourceContext) {
        List<MediaType> acceptableMediaTypes = resourceContext.getAcceptableMediaTypes();
        return this.mediaTypeParameterMatches(acceptableMediaTypes, "profile", ACCEPT_PROFILE);
    }

    protected EnumSet<SuppressionType> suppress(IResourceContext resourceContext) {
        List<MediaType> acceptableMediaTypes = resourceContext.getAcceptableMediaTypes();
        return SuppressionType.ParseUtil.parse(this.mediaTypeParameterList(acceptableMediaTypes, "suppress"));
    }

    private void appendObjectTo(IResourceContext resourceContext, ManagedObject owner, JsonRepresentation rootRepresentation, EnumSet<SuppressionType> suppression) {
        this.appendPropertiesTo(resourceContext, owner, rootRepresentation, suppression);
        Where where = resourceContext.getWhere();
        owner.getSpecification().streamCollections(Contributed.INCLUDED).forEach(collection -> {
            JsonRepresentation collectionRepresentation = JsonRepresentation.newArray();
            rootRepresentation.mapPut(collection.getId(), collectionRepresentation);
            InteractionInitiatedBy interactionInitiatedBy = resourceContext.getInteractionInitiatedBy();
            Consent visibilityConsent = collection.isVisible(owner, interactionInitiatedBy, where);
            if (!visibilityConsent.isAllowed()) {
                return;
            }
            ManagedCollection managedCollection = ManagedCollection.of((ManagedObject)owner, (OneToManyAssociation)collection, (Where)where);
            this.appendCollectionTo(resourceContext, managedCollection, collectionRepresentation, suppression);
        });
    }

    private void appendPropertiesTo(IResourceContext resourceContext, ManagedObject objectAdapter, JsonRepresentation rootRepresentation, EnumSet<SuppressionType> suppression) {
        InteractionInitiatedBy interactionInitiatedBy = resourceContext.getInteractionInitiatedBy();
        Where where = resourceContext.getWhere();
        Stream properties = objectAdapter.getSpecification().streamProperties(Contributed.INCLUDED);
        properties.forEach(property -> {
            String[] parts;
            String upHref;
            Consent visibility = property.isVisible(objectAdapter, interactionInitiatedBy, where);
            if (!visibility.isAllowed()) {
                return;
            }
            JsonRepresentation propertyRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            ObjectPropertyReprRenderer renderer = (ObjectPropertyReprRenderer)new ObjectPropertyReprRenderer(resourceContext, null, property.getId(), propertyRepresentation).asStandalone();
            renderer.with((ManagedMember)ManagedProperty.of((ManagedObject)objectAdapter, (OneToOneAssociation)property, (Where)where));
            JsonRepresentation propertyValueRepresentation = renderer.render();
            if (!suppression.contains(SuppressionType.HREF)) {
                upHref = propertyValueRepresentation.getString("links[rel=up].href");
                rootRepresentation.mapPut("$$href", upHref);
            }
            if (!suppression.contains(SuppressionType.TITLE)) {
                String upTitle = propertyValueRepresentation.getString("links[rel=up].title");
                rootRepresentation.mapPut("$$title", upTitle);
            }
            if (!suppression.contains(SuppressionType.DOMAIN_TYPE) && (parts = (upHref = propertyValueRepresentation.getString("links[rel=up].href")).split("[/]")).length > 2) {
                String upObjectType = parts[parts.length - 2];
                rootRepresentation.mapPut("$$domainType", upObjectType);
            }
            if (!suppression.contains(SuppressionType.ID) && (parts = (upHref = propertyValueRepresentation.getString("links[rel=up].href")).split("[/]")).length > 1) {
                String upInstanceId = parts[parts.length - 1];
                rootRepresentation.mapPut("$$instanceId", upInstanceId);
            }
            JsonRepresentation value = propertyValueRepresentation.getRepresentation("value", new Object[0]);
            rootRepresentation.mapPut(property.getId(), value);
        });
    }

    private void appendCollectionTo(IResourceContext resourceContext, ManagedCollection managedCollection, JsonRepresentation representation, EnumSet<SuppressionType> suppression) {
        managedCollection.streamElements(resourceContext.getInteractionInitiatedBy()).forEach(element -> this.appendElementTo(resourceContext, (ManagedObject)element, representation, suppression));
    }

    private void appendElementTo(IResourceContext resourceContext, ManagedObject elementAdapter, JsonRepresentation collectionRepresentation, EnumSet<SuppressionType> suppression) {
        JsonRepresentation elementRepresentation = JsonRepresentation.newMap((String[])new String[0]);
        this.appendPropertiesTo(resourceContext, elementAdapter, elementRepresentation, suppression);
        collectionRepresentation.arrayAdd(elementRepresentation);
    }
}

