/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service;

import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.isis.core.metamodel.interactions.managed.ManagedAction;
import org.apache.isis.core.metamodel.interactions.managed.ManagedCollection;
import org.apache.isis.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isisRoRendering.RepresentationServiceContentNegotiator")
@Order(value=-1073741824)
@Primary
@Qualifier(value="ContentNegotiator")
public class RepresentationServiceContentNegotiator
implements RepresentationService {
    @Inject
    private List<ContentNegotiationService> contentNegotiationServices;

    @Override
    public Response objectRepresentation(IResourceContext renderContext, ManagedObject objectAdapter) {
        Response.ResponseBuilder responseBuilder = this.buildResponse((ContentNegotiationService connegService) -> connegService.buildResponse(renderContext, objectAdapter));
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    @Override
    public Response propertyDetails(IResourceContext renderContext, ManagedProperty objectAndProperty) {
        Response.ResponseBuilder responseBuilder = this.buildResponse((ContentNegotiationService connegService) -> connegService.buildResponse(renderContext, objectAndProperty));
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    @Override
    public Response collectionDetails(IResourceContext renderContext, ManagedCollection objectAndCollection) {
        Response.ResponseBuilder responseBuilder = this.buildResponse((ContentNegotiationService connegService) -> connegService.buildResponse(renderContext, objectAndCollection));
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    @Override
    public Response actionPrompt(IResourceContext renderContext, ManagedAction objectAndAction) {
        Response.ResponseBuilder responseBuilder = this.buildResponse((ContentNegotiationService connegService) -> connegService.buildResponse(renderContext, objectAndAction));
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    @Override
    public Response actionResult(IResourceContext renderContext, ObjectAndActionInvocation objectAndActionInvocation) {
        Response.ResponseBuilder responseBuilder = this.buildResponse((ContentNegotiationService connegService) -> connegService.buildResponse(renderContext, objectAndActionInvocation));
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    void assertContentNegotiationServiceHandled(Response.ResponseBuilder responseBuilder) {
        if (responseBuilder == null) {
            throw new IllegalStateException("Could not locate " + ContentNegotiationService.class.getSimpleName() + " to handle request");
        }
    }

    Response.ResponseBuilder buildResponse(Function<ContentNegotiationService, Response.ResponseBuilder> connegServiceBuildResponse) {
        for (ContentNegotiationService contentNegotiationService : this.contentNegotiationServices) {
            Response.ResponseBuilder responseBuilder = connegServiceBuildResponse.apply(contentNegotiationService);
            if (responseBuilder == null) continue;
            return responseBuilder;
        }
        return null;
    }

    protected Response buildResponse(Response.ResponseBuilder responseBuilder) {
        return responseBuilder.build();
    }
}

