/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domaintypes;

import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.AbstractTypeFeatureReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ActionDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndFeature;

public class ActionParameterDescriptionReprRenderer
extends AbstractTypeFeatureReprRenderer<ActionParameterDescriptionReprRenderer, ObjectActionParameter> {
    public static LinkBuilder newLinkToBuilder(IResourceContext resourceContext, Rel rel, ObjectSpecification objectSpecification, ObjectActionParameter objectActionParameter) {
        String domainType = objectSpecification.getSpecId().asString();
        ObjectAction objectAction = objectActionParameter.getAction();
        String actionId = objectAction.getId();
        String paramName = objectActionParameter.getName();
        String url = String.format("domain-types/%s/actions/%s/params/%s", domainType, actionId, paramName);
        return LinkBuilder.newBuilder(resourceContext, rel.andParam("id", ActionParameterDescriptionReprRenderer.deriveId(objectActionParameter)), RepresentationType.ACTION_PARAMETER_DESCRIPTION, url, new Object[0]);
    }

    public ActionParameterDescriptionReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.ACTION_PARAMETER_DESCRIPTION, representation);
    }

    @Override
    public ActionParameterDescriptionReprRenderer with(ParentSpecAndFeature<ObjectActionParameter> specAndFeature) {
        super.with(specAndFeature);
        this.representation.mapPut("id", this.deriveId());
        return this;
    }

    protected String deriveId() {
        return ActionParameterDescriptionReprRenderer.deriveId((ObjectActionParameter)this.getObjectFeature());
    }

    private static String deriveId(ObjectActionParameter objectActionParameter) {
        return objectActionParameter.getAction().getId() + "-" + objectActionParameter.getName();
    }

    @Override
    protected void addLinkSelfIfRequired() {
        if (!this.includesSelf) {
            return;
        }
        this.getLinks().arrayAdd(ActionParameterDescriptionReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.SELF, this.getParentSpecification(), (ObjectActionParameter)this.getObjectFeature()).build());
    }

    @Override
    protected void addLinkUpToParent() {
        ObjectAction parentAction = ((ObjectActionParameter)this.objectFeature).getAction();
        LinkBuilder parentLinkBuilder = ActionDescriptionReprRenderer.newLinkToBuilder(this.resourceContext, Rel.UP, this.objectSpecification, parentAction);
        this.getLinks().arrayAdd(parentLinkBuilder.build());
    }

    @Override
    protected void addPropertiesSpecificToFeature() {
        this.representation.mapPut("name", ((ObjectActionParameter)this.getObjectFeature()).getName());
        this.representation.mapPut("number", ((ObjectActionParameter)this.getObjectFeature()).getNumber());
        this.representation.mapPut("optional", ((ObjectActionParameter)this.getObjectFeature()).isOptional());
        MaxLengthFacet maxLength = (MaxLengthFacet)((ObjectActionParameter)this.getObjectFeature()).getFacet(MaxLengthFacet.class);
        if (maxLength != null && !maxLength.isFallback()) {
            this.representation.mapPut("maxLength", maxLength.value());
        }
    }

    @Override
    protected void addLinksSpecificToFeature() {
        LinkBuilder linkBuilder = DomainTypeReprRenderer.newLinkToBuilder(this.resourceContext, Rel.RETURN_TYPE, ((ObjectActionParameter)this.objectFeature).getSpecification());
        this.getLinks().arrayAdd(linkBuilder.build());
    }

    @Override
    protected void putExtensionsSpecificToFeature() {
        this.putExtensionsName();
        this.putExtensionsDescriptionIfAvailable();
    }
}

