/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.collections.collection.defaultview.DefaultViewFacet;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.facets.value.bigdecimal.BigDecimalValueFacet;
import org.apache.isis.core.metamodel.facets.value.biginteger.BigIntegerValueFacet;
import org.apache.isis.core.metamodel.interactions.managed.ManagedMember;
import org.apache.isis.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.PropertyDescriptionReprRenderer;

public class ObjectPropertyReprRenderer
extends AbstractObjectMemberReprRenderer<ObjectPropertyReprRenderer, OneToOneAssociation> {
    public ObjectPropertyReprRenderer(IResourceContext context) {
        this(context, (LinkFollowSpecs)null, (String)null, JsonRepresentation.newMap((String[])new String[0]));
    }

    public ObjectPropertyReprRenderer(IResourceContext context, LinkFollowSpecs linkFollower, String propertyId, JsonRepresentation representation) {
        super(context, linkFollower, propertyId, RepresentationType.OBJECT_PROPERTY, representation, Where.OBJECT_FORMS);
    }

    @Override
    public JsonRepresentation render() {
        this.renderMemberContent();
        LinkFollowSpecs followValue = this.getLinkFollowSpecs().follow("value", new Object[0]);
        this.addValue(followValue);
        this.putDisabledReasonIfDisabled();
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addChoices();
            this.addExtensionsIsisProprietaryChangedObjects();
        }
        return this.representation;
    }

    private Object addValue(LinkFollowSpecs linkFollower) {
        boolean eagerlyRender;
        ManagedObject valueAdapterIfAny = ((OneToOneAssociation)this.objectMember).get(this.objectAdapter, this.getInteractionInitiatedBy());
        ObjectSpecification spec = valueAdapterIfAny != null ? valueAdapterIfAny.getSpecification() : ((OneToOneAssociation)this.objectMember).getSpecification();
        ValueFacet valueFacet = (ValueFacet)spec.getFacet(ValueFacet.class);
        if (valueFacet != null) {
            BigIntegerValueFacet bigIntegerValueFacet;
            String format = null;
            Class specClass = spec.getCorrespondingClass();
            if (specClass == BigDecimal.class) {
                BigDecimalValueFacet bigDecimalValueFacet = ObjectPropertyReprRenderer.getFacet(BigDecimalValueFacet.class, new FacetHolder[]{this.objectMember, valueAdapterIfAny != null ? valueAdapterIfAny.getSpecification() : null});
                if (bigDecimalValueFacet != null) {
                    Integer precision = bigDecimalValueFacet.getPrecision();
                    Integer scale = bigDecimalValueFacet.getScale();
                    format = String.format("big-decimal(%d,%d)", precision, scale);
                }
            } else if (specClass == BigInteger.class && (bigIntegerValueFacet = ObjectPropertyReprRenderer.getFacet(BigIntegerValueFacet.class, new FacetHolder[]{this.objectMember, valueAdapterIfAny != null ? valueAdapterIfAny.getSpecification() : null})) != null) {
                format = String.format("big-integer", new Object[0]);
            }
            return this.jsonValueEncoder.appendValueAndFormat(valueAdapterIfAny, spec, this.representation, format, this.resourceContext.suppressMemberExtensions());
        }
        boolean bl = eagerlyRender = this.renderEagerly() && this.resourceContext.canEagerlyRender(valueAdapterIfAny) || linkFollower != null && !linkFollower.isTerminated();
        if (valueAdapterIfAny == null) {
            NullNode value = NullNode.getInstance();
            this.representation.mapPut("value", (JsonNode)value);
            return value;
        }
        TitleFacet titleFacet = (TitleFacet)spec.getFacet(TitleFacet.class);
        String title = titleFacet.title(valueAdapterIfAny);
        LinkBuilder valueLinkBuilder = DomainObjectReprRenderer.newLinkToBuilder(this.resourceContext, Rel.VALUE, valueAdapterIfAny).withTitle(title);
        if (eagerlyRender) {
            DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.resourceContext, linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            renderer.with(valueAdapterIfAny);
            if (this.mode.isEventSerialization()) {
                renderer.asEventSerialization();
            }
            valueLinkBuilder.withValue(renderer.render());
        }
        JsonRepresentation valueJsonRepr = valueLinkBuilder.build();
        this.representation.mapPut("value", valueJsonRepr);
        return valueJsonRepr;
    }

    private boolean renderEagerly() {
        DefaultViewFacet defaultViewFacet = (DefaultViewFacet)((OneToOneAssociation)this.objectMember).getFacet(DefaultViewFacet.class);
        return defaultViewFacet != null && Objects.equals(defaultViewFacet.value(), "table");
    }

    private static <T extends Facet> T getFacet(Class<T> facetType, FacetHolder ... holders) {
        for (FacetHolder holder : holders) {
            Facet facet;
            if (holder == null || (facet = holder.getFacet(facetType)) == null) continue;
            return (T)facet;
        }
        return null;
    }

    @Override
    protected void followDetailsLink(JsonRepresentation detailsLink) {
        JsonRepresentation representation = JsonRepresentation.newMap((String[])new String[0]);
        ObjectPropertyReprRenderer renderer = new ObjectPropertyReprRenderer(this.getResourceContext(), this.getLinkFollowSpecs(), null, representation);
        ((ObjectPropertyReprRenderer)renderer.with((ManagedMember)ManagedProperty.of((ManagedObject)this.objectAdapter, (OneToOneAssociation)((OneToOneAssociation)this.objectMember), (Where)this.where))).asFollowed();
        detailsLink.mapPut("value", renderer.render());
    }

    @Override
    protected void addMutatorLinksIfEnabled() {
        if (this.usability().isVetoed()) {
            return;
        }
        Map<String, MutatorSpec> mutators = this.objectMemberType.getMutators();
        for (String mutator : mutators.keySet()) {
            MutatorSpec mutatorSpec = mutators.get(mutator);
            this.addLinkFor(mutatorSpec);
        }
    }

    private ObjectPropertyReprRenderer addChoices() {
        Object propertyChoices = this.propertyChoices();
        if (propertyChoices != null) {
            this.representation.mapPut("choices", propertyChoices);
        }
        return this;
    }

    private Object propertyChoices() {
        Can choiceAdapters = ((OneToOneAssociation)this.objectMember).getChoices(this.objectAdapter, this.getInteractionInitiatedBy());
        if (choiceAdapters == null || choiceAdapters.isEmpty()) {
            return null;
        }
        ArrayList list = _Lists.newArrayList();
        for (ManagedObject choiceAdapter : choiceAdapters) {
            list.add(DomainObjectReprRenderer.valueOrRef(this.resourceContext, super.getJsonValueEncoder(), choiceAdapter));
        }
        return list;
    }

    @Override
    protected void addLinksToFormalDomainModel() {
        if (this.resourceContext.suppressDescribedByLinks()) {
            return;
        }
        JsonRepresentation link = PropertyDescriptionReprRenderer.newLinkToBuilder(this.getResourceContext(), Rel.DESCRIBEDBY, this.objectAdapter.getSpecification(), (OneToOneAssociation)this.objectMember).build();
        this.getLinks().arrayAdd(link);
    }

    @Override
    protected void putExtensionsIsisProprietary() {
    }
}

