/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import lombok.NonNull;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.core.metamodel.facets.collections.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.interactions.managed.ActionInteraction;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ActionResultReprRenderer;

public class ObjectAndActionInvocation {
    private final ManagedObject objectAdapter;
    private final ObjectAction action;
    private final JsonRepresentation arguments;
    private final Can<ManagedObject> argAdapters;
    private final ManagedObject returnedAdapter;
    private final ActionResultReprRenderer.SelfLink selfLink;

    public static ObjectAndActionInvocation of(@NonNull ActionInteraction.Result actionInteractionResult, @NonNull JsonRepresentation argsJsonRepr, @NonNull ActionResultReprRenderer.SelfLink selfLink) {
        if (actionInteractionResult == null) {
            throw new NullPointerException("actionInteractionResult is marked non-null but is null");
        }
        if (argsJsonRepr == null) {
            throw new NullPointerException("argsJsonRepr is marked non-null but is null");
        }
        if (selfLink == null) {
            throw new NullPointerException("selfLink is marked non-null but is null");
        }
        return new ObjectAndActionInvocation(actionInteractionResult.getManagedAction().getOwner(), actionInteractionResult.getManagedAction().getAction(), argsJsonRepr, (Can<ManagedObject>)actionInteractionResult.getParameterList(), actionInteractionResult.getActionReturnedObject(), selfLink);
    }

    public ObjectAndActionInvocation(ManagedObject objectAdapter, ObjectAction action, JsonRepresentation arguments, Can<ManagedObject> argAdapters, ManagedObject returnedAdapter, ActionResultReprRenderer.SelfLink selfLink) {
        this.objectAdapter = objectAdapter;
        this.action = action;
        this.arguments = arguments;
        this.argAdapters = argAdapters;
        this.returnedAdapter = returnedAdapter;
        this.selfLink = selfLink;
    }

    public ManagedObject getObjectAdapter() {
        return this.objectAdapter;
    }

    public ObjectAction getAction() {
        return this.action;
    }

    public JsonRepresentation getArguments() {
        return this.arguments;
    }

    public Can<ManagedObject> getArgAdapters() {
        return this.argAdapters;
    }

    public ManagedObject getReturnedAdapter() {
        return this.returnedAdapter;
    }

    public ActionResultReprRenderer.SelfLink getSelfLink() {
        return this.selfLink;
    }

    public ActionResultRepresentation.ResultType determineResultType() {
        ObjectSpecification returnType = this.action.getReturnType();
        if (returnType.getCorrespondingClass() == Void.TYPE) {
            return ActionResultRepresentation.ResultType.VOID;
        }
        CollectionFacet collectionFacet = (CollectionFacet)returnType.getFacet(CollectionFacet.class);
        if (collectionFacet != null) {
            return ActionResultRepresentation.ResultType.LIST;
        }
        EncodableFacet encodableFacet = (EncodableFacet)returnType.getFacet(EncodableFacet.class);
        if (encodableFacet != null) {
            return ActionResultRepresentation.ResultType.SCALAR_VALUE;
        }
        return ActionResultRepresentation.ResultType.DOMAIN_OBJECT;
    }
}

