/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.fasterxml.jackson.databind.node.NullNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.interactions.managed.ManagedAction;
import org.apache.isis.core.metamodel.interactions.managed.ManagedMember;
import org.apache.isis.core.metamodel.interactions.managed.ParameterNegotiationModel;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.IResourceContext;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.InvokeKeys;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ActionDescriptionReprRenderer;

public class ObjectActionReprRenderer
extends AbstractObjectMemberReprRenderer<ObjectActionReprRenderer, ObjectAction> {
    public ObjectActionReprRenderer(IResourceContext resourceContext) {
        this(resourceContext, (LinkFollowSpecs)null, (String)null, JsonRepresentation.newMap((String[])new String[0]));
    }

    public ObjectActionReprRenderer(IResourceContext resourceContext, LinkFollowSpecs linkFollowSpecs, String actionId, JsonRepresentation representation) {
        super(resourceContext, linkFollowSpecs, actionId, RepresentationType.OBJECT_ACTION, representation, Where.OBJECT_FORMS);
    }

    @Override
    public JsonRepresentation render() {
        this.renderMemberContent();
        this.putDisabledReasonIfDisabled();
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addParameterDetails();
        }
        return this.representation;
    }

    @Override
    protected void followDetailsLink(JsonRepresentation detailsLink) {
        Where where = this.resourceContext.getWhere();
        ObjectActionReprRenderer renderer = new ObjectActionReprRenderer(this.getResourceContext(), this.getLinkFollowSpecs(), null, JsonRepresentation.newMap((String[])new String[0]));
        ((ObjectActionReprRenderer)((ObjectActionReprRenderer)renderer.with((ManagedMember)ManagedAction.of((ManagedObject)this.objectAdapter, (ObjectAction)((ObjectAction)this.objectMember), (Where)where))).usingLinkTo(this.linkTo)).asFollowed();
        detailsLink.mapPut("value", renderer.render());
    }

    @Override
    protected void addMutatorLinksIfEnabled() {
        if (this.usability().isVetoed()) {
            return;
        }
        Map<String, MutatorSpec> mutators = this.objectMemberType.getMutators();
        SemanticsOf actionSemantics = ((ObjectAction)this.objectMember).getSemantics();
        String mutator = InvokeKeys.getKeyFor(actionSemantics);
        MutatorSpec mutatorSpec = mutators.get(mutator);
        this.addLinkFor(mutatorSpec);
    }

    @Override
    protected ObjectAdapterLinkTo linkToForMutatorInvoke() {
        return super.linkToForMutatorInvoke();
    }

    @Override
    protected JsonRepresentation mutatorArgs(MutatorSpec mutatorSpec) {
        JsonRepresentation argMap = JsonRepresentation.newMap((String[])new String[0]);
        Can parameters = ((ObjectAction)this.objectMember).getParameters();
        for (int i = 0; i < ((ObjectAction)this.objectMember).getParameterCount(); ++i) {
            argMap.mapPut(((ObjectActionParameter)parameters.getElseFail(i)).getId() + ".value", this.argValueFor(i));
        }
        return argMap;
    }

    private Object argValueFor(int i) {
        return NullNode.getInstance();
    }

    private ObjectActionReprRenderer addParameterDetails() {
        LinkedHashMap parameters = _Maps.newLinkedHashMap();
        for (int i = 0; i < ((ObjectAction)this.objectMember).getParameterCount(); ++i) {
            ObjectActionParameter param = (ObjectActionParameter)((ObjectAction)this.objectMember).getParameters().getElseFail(i);
            Object paramDetails = this.paramDetails(param, this.getInteractionInitiatedBy());
            parameters.put(param.getId(), paramDetails);
        }
        this.representation.mapPut("parameters", (Object)parameters);
        return this;
    }

    private Object paramDetails(ObjectActionParameter param, InteractionInitiatedBy interactionInitiatedBy) {
        Object paramDefault;
        JsonRepresentation paramRep = JsonRepresentation.newMap((String[])new String[0]);
        paramRep.mapPut("num", param.getNumber());
        paramRep.mapPut("id", param.getId());
        paramRep.mapPut("name", param.getName());
        paramRep.mapPut("description", param.getDescription());
        Object paramChoices = this.choicesFor(param, interactionInitiatedBy);
        if (paramChoices != null) {
            paramRep.mapPut("choices", paramChoices);
        }
        if ((paramDefault = this.defaultFor(param)) != null) {
            paramRep.mapPut("default", paramDefault);
        }
        return paramRep;
    }

    private Object choicesFor(ObjectActionParameter param, InteractionInitiatedBy interactionInitiatedBy) {
        ParameterNegotiationModel pendingArgs = param.getAction().interactionHead(this.objectAdapter).emptyModel();
        Can choiceAdapters = param.getChoices(pendingArgs, interactionInitiatedBy);
        if (choiceAdapters == null || choiceAdapters.isEmpty()) {
            return null;
        }
        ArrayList list = _Lists.newArrayList();
        for (ManagedObject choiceAdapter : choiceAdapters) {
            list.add(DomainObjectReprRenderer.valueOrRef(this.resourceContext, super.getJsonValueEncoder(), choiceAdapter));
        }
        return list;
    }

    private Object defaultFor(ObjectActionParameter param) {
        ParameterNegotiationModel emptyPpm = param.getAction().interactionHead(this.objectAdapter).emptyModel();
        ManagedObject defaultAdapter = param.getDefault(emptyPpm);
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)defaultAdapter)) {
            return null;
        }
        return DomainObjectReprRenderer.valueOrRef(this.resourceContext, super.getJsonValueEncoder(), defaultAdapter);
    }

    @Override
    protected void addLinksToFormalDomainModel() {
        if (this.resourceContext.suppressDescribedByLinks()) {
            return;
        }
        JsonRepresentation link = ActionDescriptionReprRenderer.newLinkToBuilder(this.resourceContext, Rel.DESCRIBEDBY, this.objectAdapter.getSpecification(), (ObjectAction)this.objectMember).build();
        this.getLinks().arrayAdd(link);
    }

    @Override
    protected void putExtensionsIsisProprietary() {
        this.getExtensions().mapPut("actionType", ((ObjectAction)this.objectMember).getType().name().toLowerCase());
        SemanticsOf semantics = ((ObjectAction)this.objectMember).getSemantics();
        this.getExtensions().mapPut("actionSemantics", semantics.getCamelCaseName());
    }
}

