/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class JsonValueEncoder_Converters {
    public List<JsonValueEncoder.JsonValueConverter> asList(final Function<Object, ManagedObject> pojoToAdapter) {
        ArrayList converters = _Lists.newArrayList();
        converters.add(new JsonValueEncoder.JsonValueConverter(null, "string", new Class[]{String.class}){

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asString());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof String) {
                    repr.mapPut("value", (String)obj);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter(null, "boolean", new Class[]{Boolean.TYPE, Boolean.class}){

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isBoolean()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asBoolean());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Boolean) {
                    repr.mapPut("value", (Boolean)obj);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("int", "byte", new Class[]{Byte.TYPE, Byte.class}){

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isNumber()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asNumber().byteValue());
                }
                if (repr.isInt()) {
                    return (ManagedObject)pojoToAdapter.apply((byte)repr.asInt().intValue());
                }
                if (repr.isLong()) {
                    return (ManagedObject)pojoToAdapter.apply((byte)repr.asLong().longValue());
                }
                if (repr.isBigInteger()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asBigInteger().byteValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Byte) {
                    repr.mapPut("value", (Byte)obj);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("int", "short", new Class[]{Short.TYPE, Short.class}){

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isNumber()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asNumber().shortValue());
                }
                if (repr.isInt()) {
                    return (ManagedObject)pojoToAdapter.apply((short)repr.asInt().intValue());
                }
                if (repr.isLong()) {
                    return (ManagedObject)pojoToAdapter.apply((short)repr.asLong().longValue());
                }
                if (repr.isBigInteger()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asBigInteger().shortValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Short) {
                    repr.mapPut("value", (Short)obj);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("int", "int", new Class[]{Integer.TYPE, Integer.class}){

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isInt()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asInt());
                }
                if (repr.isLong()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asLong().intValue());
                }
                if (repr.isBigInteger()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asBigInteger().intValue());
                }
                if (repr.isNumber()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asNumber().intValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Integer) {
                    repr.mapPut("value", (Integer)obj);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("int", "long", new Class[]{Long.TYPE, Long.class}){

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isLong()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asLong());
                }
                if (repr.isInt()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asLong());
                }
                if (repr.isBigInteger()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asBigInteger().longValue());
                }
                if (repr.isNumber()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asNumber().longValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Long) {
                    Long l = (Long)obj;
                    repr.mapPut("value", l);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("decimal", "float", new Class[]{Float.TYPE, Float.class}){

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isDecimal()) {
                    return (ManagedObject)pojoToAdapter.apply(Float.valueOf(repr.asDouble().floatValue()));
                }
                if (repr.isNumber()) {
                    return (ManagedObject)pojoToAdapter.apply(Float.valueOf(repr.asNumber().floatValue()));
                }
                if (repr.isLong()) {
                    return (ManagedObject)pojoToAdapter.apply(Float.valueOf(repr.asLong().floatValue()));
                }
                if (repr.isInt()) {
                    return (ManagedObject)pojoToAdapter.apply(Float.valueOf(repr.asInt().floatValue()));
                }
                if (repr.isBigInteger()) {
                    return (ManagedObject)pojoToAdapter.apply(Float.valueOf(repr.asBigInteger().floatValue()));
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Float) {
                    Float f = (Float)obj;
                    repr.mapPut("value", f);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("decimal", "double", new Class[]{Double.TYPE, Double.class}){

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isDecimal()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asDouble());
                }
                if (repr.isLong()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asLong().doubleValue());
                }
                if (repr.isInt()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asInt().doubleValue());
                }
                if (repr.isBigInteger()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asBigInteger().doubleValue());
                }
                if (repr.isBigDecimal()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asBigDecimal().doubleValue());
                }
                if (repr.isNumber()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asNumber().doubleValue());
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Double) {
                    Double d = (Double)obj;
                    repr.mapPut("value", d);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter(null, "char", new Class[]{Character.TYPE, Character.class}){

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                Integer x;
                String str;
                if (repr.isString() && (str = repr.asString()) != null && str.length() > 0) {
                    return (ManagedObject)pojoToAdapter.apply(Character.valueOf(str.charAt(0)));
                }
                if (repr.isInt() && 0 <= (x = repr.asInt()) && x <= 65535) {
                    char c = (char)x.intValue();
                    return (ManagedObject)pojoToAdapter.apply(Character.valueOf(c));
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Character) {
                    Character c = (Character)obj;
                    repr.mapPut("value", c);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("big-integer(18)", "javamathbiginteger", new Class[]{BigInteger.class}){

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    return (ManagedObject)pojoToAdapter.apply(new BigInteger(repr.asString()));
                }
                if (repr.isBigInteger()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asBigInteger(format));
                }
                if (repr.isLong()) {
                    return (ManagedObject)pojoToAdapter.apply(BigInteger.valueOf(repr.asLong()));
                }
                if (repr.isInt()) {
                    return (ManagedObject)pojoToAdapter.apply(BigInteger.valueOf(repr.asInt().intValue()));
                }
                if (repr.isNumber()) {
                    return (ManagedObject)pojoToAdapter.apply(BigInteger.valueOf(repr.asNumber().longValue()));
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof BigInteger) {
                    BigInteger bi = (BigInteger)obj;
                    repr.mapPut("value", bi);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, format != null ? format : this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("big-decimal", "javamathbigdecimal", new Class[]{BigDecimal.class}){

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    return (ManagedObject)pojoToAdapter.apply(new BigDecimal(repr.asString()));
                }
                if (repr.isBigDecimal()) {
                    return (ManagedObject)pojoToAdapter.apply(repr.asBigDecimal(format));
                }
                if (repr.isBigInteger()) {
                    return (ManagedObject)pojoToAdapter.apply(new BigDecimal(repr.asBigInteger()));
                }
                if (repr.isDecimal()) {
                    return (ManagedObject)pojoToAdapter.apply(BigDecimal.valueOf(repr.asDouble()));
                }
                if (repr.isLong()) {
                    return (ManagedObject)pojoToAdapter.apply(BigDecimal.valueOf(repr.asLong()));
                }
                if (repr.isInt()) {
                    return (ManagedObject)pojoToAdapter.apply(BigDecimal.valueOf(repr.asInt().intValue()));
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof BigDecimal) {
                    repr.mapPut("value", (BigDecimal)obj);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, format != null ? format : this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("date", "jodalocaldate", new Class[]{LocalDate.class}){
            final List<DateTimeFormatter> formatters;
            {
                super(format, xIsisFormat, classes);
                this.formatters = Arrays.asList(ISODateTimeFormat.date(), ISODateTimeFormat.basicDate(), DateTimeFormat.forPattern((String)"yyyyMMdd"), JsonRepresentation.yyyyMMdd);
            }

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            LocalDate parsedDate = formatter.parseLocalDate(dateStr);
                            return (ManagedObject)pojoToAdapter.apply(parsedDate);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof LocalDate) {
                    LocalDate date = (LocalDate)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)date.toDateTimeAtStartOfDay());
                    repr.mapPut("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("date-time", "jodalocaldatetime", new Class[]{LocalDateTime.class}){
            final List<DateTimeFormatter> formatters;
            {
                super(format, xIsisFormat, classes);
                this.formatters = Arrays.asList(ISODateTimeFormat.dateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.dateTime().withZoneUTC(), ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.basicDateTime().withZoneUTC(), JsonRepresentation.yyyyMMddTHHmmssZ.withZoneUTC());
            }

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            LocalDateTime parsedDate = formatter.parseLocalDateTime(dateStr);
                            return (ManagedObject)pojoToAdapter.apply(parsedDate);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof LocalDateTime) {
                    LocalDateTime date = (LocalDateTime)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)date.toDateTime());
                    repr.mapPut("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("date-time", "jodadatetime", new Class[]{DateTime.class}){
            final List<DateTimeFormatter> formatters;
            {
                super(format, xIsisFormat, classes);
                this.formatters = Arrays.asList(ISODateTimeFormat.dateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.dateTime().withZoneUTC(), ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.basicDateTime().withZoneUTC(), JsonRepresentation.yyyyMMddTHHmmssZ.withZoneUTC());
            }

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            DateTime parsedDate = formatter.parseDateTime(dateStr);
                            return (ManagedObject)pojoToAdapter.apply(parsedDate);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof DateTime) {
                    DateTime date = (DateTime)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)date.toDateTime());
                    repr.mapPut("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("date-time", "javautildate", new Class[]{java.util.Date.class}){
            final List<DateTimeFormatter> formatters;
            {
                super(format, xIsisFormat, classes);
                this.formatters = Arrays.asList(ISODateTimeFormat.dateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.dateTime().withZoneUTC(), ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC(), ISODateTimeFormat.basicDateTime().withZoneUTC(), JsonRepresentation.yyyyMMddTHHmmssZ.withZoneUTC());
            }

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            DateTime parseDateTime = formatter.parseDateTime(dateStr);
                            java.util.Date parsedDate = parseDateTime.toDate();
                            return (ManagedObject)pojoToAdapter.apply(parsedDate);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)obj;
                    DateTimeFormatter dateTimeFormatter = this.formatters.get(0);
                    String dateStr = dateTimeFormatter.print((ReadableInstant)new DateTime((Object)date));
                    repr.mapPut("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("date", "javasqldate", new Class[]{Date.class}){
            final List<DateTimeFormatter> formatters;
            {
                super(format, xIsisFormat, classes);
                this.formatters = Arrays.asList(ISODateTimeFormat.date().withZoneUTC(), ISODateTimeFormat.basicDate().withZoneUTC(), JsonRepresentation.yyyyMMdd.withZoneUTC());
            }

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            DateTime parseDateTime = formatter.parseDateTime(dateStr);
                            Date parsedDate = new Date(parseDateTime.getMillis());
                            return (ManagedObject)pojoToAdapter.apply(parsedDate);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Date) {
                    Date date = (Date)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)new DateTime((Object)date));
                    repr.mapPut("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("time", "javasqltime", new Class[]{Time.class}){
            final List<DateTimeFormatter> formatters;
            {
                super(format, xIsisFormat, classes);
                this.formatters = Arrays.asList(ISODateTimeFormat.hourMinuteSecond().withZoneUTC(), ISODateTimeFormat.basicTimeNoMillis().withZoneUTC(), ISODateTimeFormat.basicTime().withZoneUTC(), JsonRepresentation._HHmmss.withZoneUTC());
            }

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    for (DateTimeFormatter formatter : this.formatters) {
                        try {
                            DateTime parseDateTime = formatter.parseDateTime(dateStr);
                            Time parsedTime = new Time(parseDateTime.getMillis());
                            return (ManagedObject)pojoToAdapter.apply(parsedTime);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Time) {
                    Time date = (Time)obj;
                    String dateStr = this.formatters.get(0).print((ReadableInstant)new DateTime((Object)date));
                    repr.mapPut("value", dateStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        converters.add(new JsonValueEncoder.JsonValueConverter("utc-millisec", "javasqltimestamp", new Class[]{Timestamp.class}){

            @Override
            public ManagedObject asAdapter(JsonRepresentation repr, String format) {
                if (repr.isLong()) {
                    Long millis = repr.asLong();
                    Timestamp parsedTimestamp = new Timestamp(millis);
                    return (ManagedObject)pojoToAdapter.apply(parsedTimestamp);
                }
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    try {
                        Long parseMillis = Long.parseLong(dateStr);
                        Timestamp parsedTimestamp = new Timestamp(parseMillis);
                        return (ManagedObject)pojoToAdapter.apply(parsedTimestamp);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return null;
            }

            @Override
            public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
                Object obj = JsonValueEncoder_Converters.unwrapAsObjectElseNullNode(objectAdapter);
                if (obj instanceof Timestamp) {
                    Timestamp date = (Timestamp)obj;
                    long millisStr = date.getTime();
                    repr.mapPut("value", millisStr);
                } else {
                    repr.mapPut("value", obj);
                }
                JsonValueEncoder_Converters.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
                return obj;
            }
        });
        return converters;
    }

    static void appendFormats(JsonRepresentation repr, String format, String xIsisFormat, boolean suppressExtensions) {
        JsonValueEncoder.appendFormats(repr, format, xIsisFormat, suppressExtensions);
    }

    static Object unwrapAsObjectElseNullNode(ManagedObject adapter) {
        return JsonValueEncoder.unwrapAsObjectElseNullNode(adapter);
    }
}

