/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.fasterxml.jackson.databind.node.NullNode;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder_Converters;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isisRoRendering.JsonValueEncoder")
@Order(value=-1073741824)
@Primary
@Qualifier(value="Default")
@Singleton
public class JsonValueEncoder {
    @Inject
    private SpecificationLoader specificationLoader;
    private Map<ObjectSpecId, JsonValueConverter> converterBySpecId = _Maps.newLinkedHashMap();

    @PostConstruct
    public void init() {
        Function<Object, ManagedObject> pojoToAdapter = pojo -> ManagedObject.of(arg_0 -> ((SpecificationLoader)this.specificationLoader).loadSpecification(arg_0), (Object)pojo);
        new JsonValueEncoder_Converters().asList(pojoToAdapter).forEach(this::registerConverter);
    }

    private void registerConverter(JsonValueConverter jvc) {
        for (ObjectSpecId specId : jvc.getSpecIds()) {
            this.converterBySpecId.put(specId, jvc);
        }
    }

    public ManagedObject asAdapter(ObjectSpecification objectSpec, JsonRepresentation argValueRepr, String format) {
        if (argValueRepr == null) {
            return null;
        }
        if (objectSpec == null) {
            throw new IllegalArgumentException("ObjectSpecification is required");
        }
        if (!argValueRepr.isValue()) {
            throw new IllegalArgumentException("Representation must be of a value");
        }
        EncodableFacet encodableFacet = (EncodableFacet)objectSpec.getFacet(EncodableFacet.class);
        if (encodableFacet == null) {
            String reason = "ObjectSpec expected to have an EncodableFacet";
            throw new IllegalArgumentException(reason);
        }
        ObjectSpecId specId = objectSpec.getSpecId();
        JsonValueConverter jvc = this.converterBySpecId.get(specId);
        if (jvc == null) {
            if (argValueRepr.isString()) {
                String argStr = argValueRepr.asString();
                return encodableFacet.fromEncodedString(argStr);
            }
            throw new IllegalArgumentException("Unable to parse value");
        }
        ManagedObject asAdapter = jvc.asAdapter(argValueRepr, format);
        if (asAdapter != null) {
            return asAdapter;
        }
        if (argValueRepr.isString()) {
            String argStr = argValueRepr.asString();
            try {
                return encodableFacet.fromEncodedString(argStr);
            }
            catch (TextEntryParseException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        throw new IllegalArgumentException("Could not parse value '" + argValueRepr.asString() + "' as a " + objectSpec.getFullIdentifier());
    }

    public Object appendValueAndFormat(ManagedObject objectAdapter, ObjectSpecification objectSpecification, JsonRepresentation repr, String format, boolean suppressExtensions) {
        ObjectSpecId specId = objectSpecification.getSpecId();
        JsonValueConverter jsonValueConverter = this.converterBySpecId.get(specId);
        if (jsonValueConverter != null) {
            return jsonValueConverter.appendValueAndFormat(objectAdapter, format, repr, suppressExtensions);
        }
        EncodableFacet encodableFacet = (EncodableFacet)objectSpecification.getFacet(EncodableFacet.class);
        if (encodableFacet == null) {
            throw _Exceptions.illegalArgument((String)"objectSpec '%s' expected to have EncodableFacet or a registered JsonValueConverter", (Object[])new Object[]{specId});
        }
        NullNode value = objectAdapter != null ? encodableFacet.toEncodedString(objectAdapter) : NullNode.getInstance();
        repr.mapPut("value", (Object)value);
        JsonValueEncoder.appendFormats(repr, "string", "string", suppressExtensions);
        return value;
    }

    public Object asObject(ManagedObject adapter, String format) {
        _With.requires((Object)adapter, (String)"adapter");
        ObjectSpecification objectSpec = adapter.getSpecification();
        JsonValueConverter jsonValueConverter = this.converterBySpecId.get(objectSpec.getSpecId());
        if (jsonValueConverter != null) {
            return jsonValueConverter.asObject(adapter, format);
        }
        EncodableFacet encodableFacet = (EncodableFacet)objectSpec.getFacet(EncodableFacet.class);
        if (encodableFacet == null) {
            throw new IllegalArgumentException("objectSpec expected to have EncodableFacet");
        }
        return encodableFacet.toEncodedString(adapter);
    }

    static void appendFormats(JsonRepresentation repr, String format, String xIsisFormat, boolean suppressExtensions) {
        if (format != null) {
            repr.mapPut("format", format);
        }
        if (!suppressExtensions && xIsisFormat != null) {
            repr.mapPut("extensions.x-isis-format", xIsisFormat);
        }
    }

    static Object unwrapAsObjectElseNullNode(ManagedObject adapter) {
        return adapter != null ? adapter.getPojo() : NullNode.getInstance();
    }

    public static JsonValueEncoder forTesting(SpecificationLoader specificationLoader) {
        JsonValueEncoder jsonValueEncoder = new JsonValueEncoder();
        jsonValueEncoder.specificationLoader = specificationLoader;
        jsonValueEncoder.init();
        return jsonValueEncoder;
    }

    public static abstract class JsonValueConverter {
        protected final String format;
        protected final String xIsisFormat;
        private final Class<?>[] classes;

        public JsonValueConverter(String format, String xIsisFormat, Class<?> ... classes) {
            this.format = format;
            this.xIsisFormat = xIsisFormat;
            this.classes = classes;
        }

        public List<ObjectSpecId> getSpecIds() {
            return _NullSafe.stream((Object[])this.classes).map(cls -> ObjectSpecId.of((String)cls.getName())).collect(Collectors.toList());
        }

        public abstract ManagedObject asAdapter(JsonRepresentation var1, String var2);

        public Object appendValueAndFormat(ManagedObject objectAdapter, String format, JsonRepresentation repr, boolean suppressExtensions) {
            Object value = JsonValueEncoder.unwrapAsObjectElseNullNode(objectAdapter);
            repr.mapPut("value", value);
            JsonValueEncoder.appendFormats(repr, this.format, this.xIsisFormat, suppressExtensions);
            return value;
        }

        public Object asObject(ManagedObject objectAdapter, String format) {
            return objectAdapter.getPojo();
        }
    }

    public static class ExpectedStringRepresentingValueException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
    }
}

