/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering;

import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.ExceptionWithBody;
import org.apache.isis.viewer.restfulobjects.rendering.ExceptionWithHttpStatusCode;

public class RestfulObjectsApplicationException
extends RuntimeException
implements ExceptionWithHttpStatusCode,
ExceptionWithBody {
    private static final long serialVersionUID = 1L;
    private final RestfulResponse.HttpStatusCode httpStatusCode;
    private final JsonRepresentation body;

    public static final RestfulObjectsApplicationException create(RestfulResponse.HttpStatusCode httpStatusCode) {
        return RestfulObjectsApplicationException.createWithCause(httpStatusCode, null);
    }

    public static RestfulObjectsApplicationException createWithMessage(RestfulResponse.HttpStatusCode httpStatusCode, String message, Object ... args) {
        return RestfulObjectsApplicationException.createWithCauseAndMessage(httpStatusCode, null, message, args);
    }

    public static RestfulObjectsApplicationException createWithCause(RestfulResponse.HttpStatusCode httpStatusCode, Exception cause) {
        return RestfulObjectsApplicationException.createWithCauseAndMessage(httpStatusCode, cause, null, new Object[0]);
    }

    public static RestfulObjectsApplicationException createWithCauseAndMessage(RestfulResponse.HttpStatusCode httpStatusCode, Exception cause, String message, Object ... args) {
        return new RestfulObjectsApplicationException(httpStatusCode, RestfulObjectsApplicationException.formatString(message, args), cause, null);
    }

    public static RestfulObjectsApplicationException createWithBody(RestfulResponse.HttpStatusCode httpStatusCode, JsonRepresentation body, String message, Object ... args) {
        return new RestfulObjectsApplicationException(httpStatusCode, RestfulObjectsApplicationException.formatString(message, args), null, body);
    }

    private static String formatString(String formatStr, Object ... args) {
        return formatStr != null ? String.format(formatStr, args) : null;
    }

    protected RestfulObjectsApplicationException(RestfulResponse.HttpStatusCode httpStatusCode, String message, Throwable cause, JsonRepresentation body) {
        super(message, cause);
        this.httpStatusCode = httpStatusCode;
        this.body = body;
    }

    @Override
    public RestfulResponse.HttpStatusCode getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Override
    public JsonRepresentation getBody() {
        return this.body;
    }
}

