/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.core.config.environment.IsisSystemEnvironment;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonMapper;
import org.apache.isis.viewer.restfulobjects.rendering.Caching;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.util.JsonWriterUtil;

public final class Responses {
    private Responses() {
    }

    public static Response.ResponseBuilder ofNoContent() {
        return Responses.of(RestfulResponse.HttpStatusCode.NO_CONTENT);
    }

    public static Response.ResponseBuilder ofNotFound() {
        return Responses.of(RestfulResponse.HttpStatusCode.NOT_FOUND);
    }

    public static Response.ResponseBuilder ofOk(ReprRenderer<?, ?> renderer, Caching caching) {
        return Responses.ofOk(renderer, caching, null);
    }

    public static Response.ResponseBuilder ofOk(ReprRenderer<?, ?> renderer, Caching caching, JsonRepresentation rootRepresentationIfAny) {
        JsonRepresentation representation = renderer.render();
        JsonRepresentation entityRepresentation = rootRepresentationIfAny != null ? rootRepresentationIfAny : representation;
        MediaType mediaType = renderer.getMediaType();
        Date now = Responses.now(renderer);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Response.ResponseBuilder response = Responses.of(RestfulResponse.HttpStatusCode.OK).header("Date", (Object)dateFormat.format(now)).type(mediaType).cacheControl(caching.getCacheControl()).entity((Object)JsonWriterUtil.jsonFor((Object)entityRepresentation, Responses.inferPrettyPrinting(renderer)));
        return response;
    }

    private static Date now(ReprRenderer<?, ?> renderer) {
        if (renderer instanceof ReprRendererAbstract) {
            ((ClockService)((ReprRendererAbstract)renderer).getResourceContext().getServiceRegistry().lookupServiceElseFail(ClockService.class)).nowAsJavaUtilDate();
        }
        return new Date();
    }

    protected static Response.ResponseBuilder of(RestfulResponse.HttpStatusCode httpStatusCode) {
        return Response.status((Response.StatusType)httpStatusCode.getJaxrsStatusType()).type(MediaType.APPLICATION_JSON_TYPE);
    }

    public static Response.ResponseBuilder mediaType(Response.ResponseBuilder responseBuilder, MediaType mediaType) {
        responseBuilder.type(mediaType);
        return responseBuilder;
    }

    public static JsonMapper.PrettyPrinting inferPrettyPrinting(ReprRenderer<?, ?> renderer) {
        if (renderer instanceof ReprRendererAbstract) {
            IsisSystemEnvironment systemEnvironment = ((ReprRendererAbstract)renderer).getResourceContext().getMetaModelContext().getSystemEnvironment();
            return systemEnvironment.isPrototyping() ? JsonMapper.PrettyPrinting.ENABLE : JsonMapper.PrettyPrinting.DISABLE;
        }
        return JsonMapper.PrettyPrinting.DISABLE;
    }
}

