/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering;

import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.security.authentication.AuthenticationSessionTracker;
import org.apache.isis.viewer.restfulobjects.rendering.UrlDecoderUtils;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;

public interface IResourceContext {
    public String urlFor(String var1);

    public List<MediaType> getAcceptableMediaTypes();

    public InteractionInitiatedBy getInteractionInitiatedBy();

    public Where getWhere();

    public ObjectAdapterLinkTo getObjectAdapterLinkTo();

    public List<List<String>> getFollowLinks();

    public boolean isValidateOnly();

    public boolean honorUiHints();

    public boolean objectPropertyValuesOnly();

    public boolean suppressDescribedByLinks();

    public boolean suppressUpdateLink();

    public boolean suppressMemberId();

    public boolean suppressMemberLinks();

    public boolean suppressMemberExtensions();

    public boolean suppressMemberDisabledReason();

    public boolean canEagerlyRender(ManagedObject var1);

    public RepresentationService.Intent getIntent();

    public AuthenticationSessionTracker getAuthenticationSessionTracker();

    public SpecificationLoader getSpecificationLoader();

    public MetaModelContext getMetaModelContext();

    public ServiceRegistry getServiceRegistry();

    public IsisConfiguration getConfiguration();

    default public Optional<ManagedObject> getObjectAdapterForOidFromHref(String oidFromHref) {
        String oidStrUnencoded = UrlDecoderUtils.urlDecode(oidFromHref);
        RootOid rootOid = RootOid.deString((String)oidStrUnencoded);
        return Optional.ofNullable(rootOid.loadObject(this.getSpecificationLoader()));
    }
}

