/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.isis.core.internaltestsupport.jmocking.JUnitRuleMockery2;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.jmock.Expectations;
import org.jmock.auto.Mock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class JsonValueEncoderTest_asObject {
    @Rule
    public JUnitRuleMockery2 context = JUnitRuleMockery2.createFor((JUnitRuleMockery2.Mode)JUnitRuleMockery2.Mode.INTERFACES_AND_CLASSES);
    @Mock
    private ObjectSpecification mockObjectSpec;
    @Mock
    private EncodableFacet mockEncodableFacet;
    @Mock
    private ManagedObject mockObjectAdapter;
    @Mock
    private SpecificationLoader specLoader;
    private JsonValueEncoder jsonValueEncoder;

    @Before
    public void setUp() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ManagedObject)this.allowing(JsonValueEncoderTest_asObject.this.mockObjectAdapter)).getSpecification();
                this.will(1.returnValue((Object)JsonValueEncoderTest_asObject.this.mockObjectSpec));
            }
        });
        this.jsonValueEncoder = JsonValueEncoder.forTesting((SpecificationLoader)this.specLoader);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenAdapterIsNull() throws Exception {
        this.jsonValueEncoder.asObject(null, null);
    }

    @Test
    public void whenBooleanPrimitive() throws Exception {
        this.whenBoolean(Boolean.TYPE);
    }

    @Test
    public void whenBooleanWrapper() throws Exception {
        this.whenBoolean(Boolean.class);
    }

    private void whenBoolean(Class<?> cls) {
        this.allowingObjectSpecCorrespondingClassIs(cls);
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.never(this.mockEncodableFacet);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ManagedObject)this.oneOf(JsonValueEncoderTest_asObject.this.mockObjectAdapter)).getPojo();
                this.will(2.returnValue((Object)true));
            }
        });
        Assert.assertEquals((Object)true, (Object)this.jsonValueEncoder.asObject(this.mockObjectAdapter, null));
    }

    @Test
    public void whenIntegerPrimitive() throws Exception {
        this.whenInteger(Integer.TYPE);
    }

    @Test
    public void whenIntegerWrapper() throws Exception {
        this.whenInteger(Integer.class);
    }

    private void whenInteger(Class<?> cls) {
        this.allowingObjectSpecCorrespondingClassIs(cls);
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.never(this.mockEncodableFacet);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ManagedObject)this.oneOf(JsonValueEncoderTest_asObject.this.mockObjectAdapter)).getPojo();
                this.will(3.returnValue((Object)123));
            }
        });
        Assert.assertEquals((Object)123, (Object)this.jsonValueEncoder.asObject(this.mockObjectAdapter, null));
    }

    @Test
    public void whenLongPrimitive() throws Exception {
        this.whenLong(Long.TYPE);
    }

    @Test
    public void whenLongWrapper() throws Exception {
        this.whenLong(Long.class);
    }

    private void whenLong(Class<?> cls) {
        this.allowingObjectSpecCorrespondingClassIs(cls);
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.never(this.mockEncodableFacet);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ManagedObject)this.oneOf(JsonValueEncoderTest_asObject.this.mockObjectAdapter)).getPojo();
                this.will(4.returnValue((Object)123456789L));
            }
        });
        Assert.assertEquals((Object)123456789L, (Object)this.jsonValueEncoder.asObject(this.mockObjectAdapter, null));
    }

    @Test
    public void whenDoublePrimitive() throws Exception {
        this.whenDouble(Double.TYPE);
    }

    @Test
    public void whenDoubleWrapper() throws Exception {
        this.whenDouble(Double.class);
    }

    private void whenDouble(Class<?> cls) {
        this.allowingObjectSpecCorrespondingClassIs(cls);
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.never(this.mockEncodableFacet);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ManagedObject)this.oneOf(JsonValueEncoderTest_asObject.this.mockObjectAdapter)).getPojo();
                this.will(5.returnValue((Object)12345.6789));
            }
        });
        Assert.assertEquals((Object)12345.6789, (Object)this.jsonValueEncoder.asObject(this.mockObjectAdapter, null));
    }

    @Test
    public void whenBigInteger() throws Exception {
        this.allowingObjectSpecCorrespondingClassIs(BigInteger.class);
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.never(this.mockEncodableFacet);
        final BigInteger value = new BigInteger("123456789012345");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ManagedObject)this.oneOf(JsonValueEncoderTest_asObject.this.mockObjectAdapter)).getPojo();
                this.will(6.returnValue((Object)value));
            }
        });
        Assert.assertEquals((Object)value, (Object)this.jsonValueEncoder.asObject(this.mockObjectAdapter, null));
    }

    @Test
    public void whenBigDecimal() throws Exception {
        this.allowingObjectSpecCorrespondingClassIs(BigDecimal.class);
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.never(this.mockEncodableFacet);
        final BigDecimal value = new BigDecimal("1234567890.1234567890");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ManagedObject)this.oneOf(JsonValueEncoderTest_asObject.this.mockObjectAdapter)).getPojo();
                this.will(7.returnValue((Object)value));
            }
        });
        Assert.assertEquals((Object)value, (Object)this.jsonValueEncoder.asObject(this.mockObjectAdapter, null));
    }

    @Test
    public void whenString() throws Exception {
        this.allowingObjectSpecCorrespondingClassIs(String.class);
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ManagedObject)this.oneOf(JsonValueEncoderTest_asObject.this.mockObjectAdapter)).getPojo();
                this.will(8.returnValue((Object)"encodedString"));
            }
        });
        Object actual = this.jsonValueEncoder.asObject(this.mockObjectAdapter, null);
        Assert.assertSame((Object)"encodedString", (Object)actual);
    }

    private void allowingObjectSpecCorrespondingClassIs(final Class<?> result) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectSpecification)this.allowing(JsonValueEncoderTest_asObject.this.mockObjectSpec)).getCorrespondingClass();
                this.will(9.returnValue((Object)result));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectSpecification)this.allowing(JsonValueEncoderTest_asObject.this.mockObjectSpec)).getSpecId();
                this.will(10.returnValue((Object)ObjectSpecId.of((String)result.getName())));
            }
        });
    }

    private <T extends Facet> void allowingObjectSpecHas(final Class<T> facetClass, final T encodableFacet) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectSpecification)this.allowing(JsonValueEncoderTest_asObject.this.mockObjectSpec)).getFacet(facetClass);
                this.will(11.returnValue((Object)encodableFacet));
            }
        });
    }

    private void never(final EncodableFacet encodableFacet2) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.never(encodableFacet2);
            }
        });
    }
}

