/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering;

import java.util.List;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.util.Parser;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class LinkFollowSpecsTest_follow {
    @Test
    public void simple() throws Exception {
        List<List<String>> links = this.asListOfLists("a.b.c");
        LinkFollowSpecs linkFollower = LinkFollowSpecs.create(links);
        MatcherAssert.assertThat((Object)linkFollower.follow("a", new Object[0]).isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)linkFollower.follow("a", new Object[0]).isTerminated(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void notMatching() throws Exception {
        List<List<String>> links = this.asListOfLists("a.b.c");
        LinkFollowSpecs linkFollower = LinkFollowSpecs.create(links);
        MatcherAssert.assertThat((Object)linkFollower.follow("x", new Object[0]).isFollowing(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)linkFollower.follow("x", new Object[0]).isTerminated(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void create_noCriteria() throws Exception {
        List<List<String>> links = this.asListOfLists("a.b.c");
        LinkFollowSpecs linkFollower = LinkFollowSpecs.create(links);
        MatcherAssert.assertThat((Object)linkFollower.matches(JsonRepresentation.newMap((String[])new String[0])), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void follow_noCriteria() throws Exception {
        List<List<String>> links = this.asListOfLists("a.b.c");
        LinkFollowSpecs linkFollower = LinkFollowSpecs.create(links);
        MatcherAssert.assertThat((Object)linkFollower.matches(JsonRepresentation.newMap((String[])new String[0])), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void follow_withSingleListCriteria() throws Exception {
        List<List<String>> links = this.asListOfLists("a[x=y].b.c");
        LinkFollowSpecs linkFollower = LinkFollowSpecs.create(links);
        MatcherAssert.assertThat((Object)linkFollower.follow("x", new Object[0]).isFollowing(), (Matcher)CoreMatchers.is((Object)false));
        LinkFollowSpecs followA = linkFollower.follow("a", new Object[0]);
        MatcherAssert.assertThat((Object)followA.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[]{"x", "y"})), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[0])), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[]{"x", "z"})), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void follow_withSingleMapCriteria() throws Exception {
        List<List<String>> links = this.asListOfLists("a[x].b.c");
        LinkFollowSpecs linkFollower = LinkFollowSpecs.create(links);
        MatcherAssert.assertThat((Object)linkFollower.follow("x", new Object[0]).isFollowing(), (Matcher)CoreMatchers.is((Object)false));
        LinkFollowSpecs followA = linkFollower.follow("a", new Object[0]);
        MatcherAssert.assertThat((Object)followA.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[]{"x", "y"})), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[]{"x", "z"})), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[0])), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[]{"p", "z"})), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void follow_withMultipleCriteria() throws Exception {
        List<List<String>> links = this.asListOfLists("a[x=y z=w].b.c");
        LinkFollowSpecs linkFollower = LinkFollowSpecs.create(links);
        MatcherAssert.assertThat((Object)linkFollower.follow("x", new Object[0]).isFollowing(), (Matcher)CoreMatchers.is((Object)false));
        LinkFollowSpecs followA = linkFollower.follow("a", new Object[0]);
        MatcherAssert.assertThat((Object)followA.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[]{"x", "y", "z", "w"})), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[]{"x", "y", "z", "w", "foo", "bar"})), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[0])), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[]{"x", "y"})), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[]{"x", "y", "foo", "bar"})), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[]{"x", "bad"})), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followA.matches(JsonRepresentation.newMap((String[])new String[]{"x", "y", "z", "bad"})), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void simple_multiplePaths() throws Exception {
        List<List<String>> links = this.asListOfLists("a.b.c,x.y.z");
        LinkFollowSpecs linkFollower = LinkFollowSpecs.create(links);
        LinkFollowSpecs followA = linkFollower.follow("a", new Object[0]);
        MatcherAssert.assertThat((Object)followA.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followA.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        LinkFollowSpecs followX = linkFollower.follow("x", new Object[0]);
        MatcherAssert.assertThat((Object)followX.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followX.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        LinkFollowSpecs followXY = followX.follow("y", new Object[0]);
        MatcherAssert.assertThat((Object)followXY.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followXY.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        LinkFollowSpecs followXYZ = followXY.follow("z", new Object[0]);
        MatcherAssert.assertThat((Object)followXYZ.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followXYZ.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        LinkFollowSpecs followXYZQ = followXY.follow("q", new Object[0]);
        MatcherAssert.assertThat((Object)followXYZQ.isFollowing(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followXYZQ.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void multiplePaths_withCriteria() throws Exception {
        List<List<String>> links = this.asListOfLists("links[rel=urn:org.restfulobjects:rels/version].x,links[rel=urn:org.restfulobjects:rels/user].y");
        LinkFollowSpecs linkFollower = LinkFollowSpecs.create(links);
        LinkFollowSpecs followRelVersion = linkFollower.follow("links[rel=urn:org.restfulobjects:rels/version]", new Object[0]);
        MatcherAssert.assertThat((Object)followRelVersion.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followRelVersion.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followRelVersion.follow("x", new Object[0]).isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        LinkFollowSpecs followRelUser = linkFollower.follow("links[rel=urn:org.restfulobjects:rels/user]", new Object[0]);
        MatcherAssert.assertThat((Object)followRelUser.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followRelUser.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followRelUser.follow("y", new Object[0]).isFollowing(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void multiplePaths_withRelFullCriteria() throws Exception {
        List<List<String>> links = this.asListOfLists("links[rel=urn:org.restfulobjects:rels/details;action=foo].x,links[rel=urn:org.restfulobjects:rels/details;action=bar].y");
        LinkFollowSpecs linkFollower = LinkFollowSpecs.create(links);
        LinkFollowSpecs followRelVersion = linkFollower.follow("links[rel=urn:org.restfulobjects:rels/details;action=foo]", new Object[0]);
        MatcherAssert.assertThat((Object)followRelVersion.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followRelVersion.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followRelVersion.follow("x", new Object[0]).isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        LinkFollowSpecs followRelUser = linkFollower.follow("links[rel=urn:org.restfulobjects:rels/details;action=bar]", new Object[0]);
        MatcherAssert.assertThat((Object)followRelUser.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followRelUser.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followRelUser.follow("y", new Object[0]).isFollowing(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void multiplePaths_withRelSimplifiedCriteria() throws Exception {
        List<List<String>> links = this.asListOfLists("links[rel=urn:org.restfulobjects:rels/details;action=foo].x,links[rel=urn:org.restfulobjects:rels/details;action=bar].y");
        LinkFollowSpecs linkFollower = LinkFollowSpecs.create(links);
        LinkFollowSpecs followRelVersion = linkFollower.follow("links[rel=urn:org.restfulobjects:rels/details]", new Object[0]);
        MatcherAssert.assertThat((Object)followRelVersion.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followRelVersion.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followRelVersion.follow("x", new Object[0]).isFollowing(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void example_of_eager_loading_of_collection() throws Exception {
        List<List<String>> links = this.asListOfLists("members[children].value");
        LinkFollowSpecs linkFollower = LinkFollowSpecs.create(links);
        LinkFollowSpecs followMembers = linkFollower.follow("members[children]", new Object[0]);
        MatcherAssert.assertThat((Object)followMembers.isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followMembers.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)followMembers.follow("value", new Object[0]).isFollowing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)followMembers.follow("value", new Object[0]).isTerminated(), (Matcher)CoreMatchers.is((Object)false));
    }

    private List<List<String>> asListOfLists(String string) {
        return (List)Parser.forListOfListOfStrings().valueOf(string);
    }
}

