/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal;

import org.apache.isis.viewer.restfulobjects.rendering.service.swagger.internal.TaggerDefault;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TaggerTest {

    public static class TagFor
    extends TaggerTest {
        @Test
        public void fullyQualifiedClass() throws Exception {
            String tag = new TaggerDefault().tagForObjectType("foo.bar.Abc", null);
            Assert.assertThat((Object)tag, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"bar")));
        }

        @Test
        public void jaxb() throws Exception {
            String tag = new TaggerDefault().tagForObjectType("todoapp.app.viewmodels.todoitem.v1_0.ToDoItemDto", null);
            Assert.assertThat((Object)tag, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"todoitem")));
        }

        @Test
        public void schemaClass() throws Exception {
            String tag = new TaggerDefault().tagForObjectType("bar.Abc", null);
            Assert.assertThat((Object)tag, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"bar")));
        }

        @Test
        public void noPackage() throws Exception {
            String tag = new TaggerDefault().tagForObjectType("Abc", null);
            Assert.assertThat((Object)tag, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Abc")));
        }

        @Test
        public void internals() throws Exception {
            String tag = new TaggerDefault().tagForObjectType("org.apache.isis.applib.fixturescripts.FixtureResult", null);
            Assert.assertThat((Object)tag, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)". apache isis internals")));
        }

        @Test
        public void applib() throws Exception {
            String tag = new TaggerDefault().tagForObjectType("isisApplib.ConfigurationServiceMenu", null);
            Assert.assertThat((Object)tag, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)". apache isis applib")));
        }
    }
}

