/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.isis.core.internaltestsupport.jmocking.JUnitRuleMockery2;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.auto.Mock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class JsonValueEncoderTest_asAdapter {
    @Rule
    public JUnitRuleMockery2 context = JUnitRuleMockery2.createFor((JUnitRuleMockery2.Mode)JUnitRuleMockery2.Mode.INTERFACES_AND_CLASSES);
    @Mock
    private ObjectSpecification mockObjectSpec;
    @Mock
    private EncodableFacet mockEncodableFacet;
    @Mock
    private ManagedObject mockObjectAdapter;
    @Mock
    private SpecificationLoader specLoader;
    private JsonRepresentation representation;
    private JsonValueEncoder jsonValueEncoder;

    @Before
    public void setUp() throws Exception {
        this.jsonValueEncoder = JsonValueEncoder.forTesting((SpecificationLoader)this.specLoader);
        this.representation = new JsonRepresentation((JsonNode)TextNode.valueOf((String)"aString"));
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenSpecIsNull() throws Exception {
        this.jsonValueEncoder.asAdapter(null, this.representation, null);
    }

    @Test
    public void whenReprIsNull() throws Exception {
        Assert.assertThat((Object)this.jsonValueEncoder.asAdapter(this.mockObjectSpec, null, null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenReprIsAnArray() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.jsonValueEncoder.asAdapter(this.mockObjectSpec, JsonRepresentation.newArray(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenReprIsAMap() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        Assert.assertNull((Object)this.jsonValueEncoder.asAdapter(this.mockObjectSpec, JsonRepresentation.newMap((String[])new String[0]), null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenSpecDoesNotHaveAnEncodableFacet() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, null);
        Assert.assertNull((Object)this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null));
    }

    @Test
    public void whenReprIsBooleanPrimitive() throws Exception {
        this.whenReprIsBoolean(Boolean.TYPE);
    }

    @Test
    public void whenReprIsBooleanWrapper() throws Exception {
        this.whenReprIsBoolean(Boolean.class);
    }

    private void whenReprIsBoolean(Class<?> correspondingClass) {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(correspondingClass);
        boolean value = true;
        this.representation = new JsonRepresentation((JsonNode)BooleanNode.valueOf((boolean)true));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SpecificationLoader)this.oneOf(JsonValueEncoderTest_asAdapter.this.specLoader)).loadSpecification(Boolean.valueOf(true).getClass());
                this.will(1.returnValue((Object)JsonValueEncoderTest_asAdapter.this.mockObjectSpec));
            }
        });
        ManagedObject adapter = this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
        Assert.assertSame((Object)this.mockObjectSpec, (Object)adapter.getSpecification());
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenObjectSpecIsBooleanButReprIsNot() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(Boolean.TYPE);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EncodableFacet)this.oneOf(JsonValueEncoderTest_asAdapter.this.mockEncodableFacet)).fromEncodedString("aString");
                this.will(2.throwException((Throwable)new TextEntryParseException("'aString' cannot be parsed as a boolean value")));
            }
        });
        this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
    }

    @Test
    public void whenReprIsIntegerPrimitive() throws Exception {
        this.whenReprIsInteger(Integer.TYPE);
    }

    @Test
    public void whenReprIsIntegerWrapper() throws Exception {
        this.whenReprIsInteger(Integer.class);
    }

    private void whenReprIsInteger(Class<?> correspondingClass) {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(correspondingClass);
        int value = 123;
        this.representation = new JsonRepresentation((JsonNode)IntNode.valueOf((int)123));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SpecificationLoader)this.oneOf(JsonValueEncoderTest_asAdapter.this.specLoader)).loadSpecification(Integer.valueOf(123).getClass());
                this.will(3.returnValue((Object)JsonValueEncoderTest_asAdapter.this.mockObjectSpec));
            }
        });
        ManagedObject adapter = this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
        Assert.assertSame((Object)this.mockObjectSpec, (Object)adapter.getSpecification());
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenObjectSpecIsIntegerButReprIsNot() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(Integer.TYPE);
        this.representation = JsonRepresentation.newMap((String[])new String[]{"foo", "bar"});
        this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
    }

    @Test
    public void whenReprIsLongPrimitive() throws Exception {
        this.whenReprIsLong(Long.TYPE);
    }

    @Test
    public void whenReprIsLongWrapper() throws Exception {
        this.whenReprIsLong(Long.class);
    }

    private void whenReprIsLong(Class<?> correspondingClass) {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(correspondingClass);
        long value = 1234567890L;
        this.representation = new JsonRepresentation((JsonNode)LongNode.valueOf((long)1234567890L));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SpecificationLoader)this.oneOf(JsonValueEncoderTest_asAdapter.this.specLoader)).loadSpecification(Long.valueOf(1234567890L).getClass());
                this.will(4.returnValue((Object)JsonValueEncoderTest_asAdapter.this.mockObjectSpec));
            }
        });
        ManagedObject adapter = this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
        Assert.assertSame((Object)this.mockObjectSpec, (Object)adapter.getSpecification());
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenObjectSpecIsLongButReprIsNot() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(Long.TYPE);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EncodableFacet)this.oneOf(JsonValueEncoderTest_asAdapter.this.mockEncodableFacet)).fromEncodedString("aString");
                this.will(5.throwException((Throwable)new TextEntryParseException("'aString' cannot be parsed as a long value")));
            }
        });
        this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
    }

    @Test
    public void whenReprIsDoublePrimitive() throws Exception {
        this.whenReprIsDouble(Double.TYPE);
    }

    @Test
    public void whenReprIsDoubleWrapper() throws Exception {
        this.whenReprIsDouble(Double.class);
    }

    private void whenReprIsDouble(Class<?> correspondingClass) {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(correspondingClass);
        double value = 123.45;
        this.representation = new JsonRepresentation((JsonNode)DoubleNode.valueOf((double)123.45));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SpecificationLoader)this.oneOf(JsonValueEncoderTest_asAdapter.this.specLoader)).loadSpecification(Double.valueOf(123.45).getClass());
                this.will(6.returnValue((Object)JsonValueEncoderTest_asAdapter.this.mockObjectSpec));
            }
        });
        ManagedObject adapter = this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
        Assert.assertSame((Object)this.mockObjectSpec, (Object)adapter.getSpecification());
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenObjectSpecIsDoubleButReprIsNot() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(Double.TYPE);
        this.representation = JsonRepresentation.newMap((String[])new String[]{"foo", "bar"});
        this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
    }

    @Test
    public void whenReprIsBigInteger() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(BigInteger.class);
        final BigInteger value = BigInteger.valueOf(123L);
        this.representation = new JsonRepresentation((JsonNode)BigIntegerNode.valueOf((BigInteger)value));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SpecificationLoader)this.oneOf(JsonValueEncoderTest_asAdapter.this.specLoader)).loadSpecification(value.getClass());
                this.will(7.returnValue((Object)JsonValueEncoderTest_asAdapter.this.mockObjectSpec));
            }
        });
        ManagedObject adapter = this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
        Assert.assertSame((Object)this.mockObjectSpec, (Object)adapter.getSpecification());
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenObjectSpecIsBigIntegerButReprIsNot() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(BigInteger.class);
        this.representation = JsonRepresentation.newMap((String[])new String[]{"foo", "bar"});
        this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
    }

    @Test
    public void whenReprIsBigDecimal() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(BigDecimal.class);
        final BigDecimal value = new BigDecimal("123234234.45612312343535");
        this.representation = new JsonRepresentation((JsonNode)DecimalNode.valueOf((BigDecimal)value));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SpecificationLoader)this.oneOf(JsonValueEncoderTest_asAdapter.this.specLoader)).loadSpecification(value.getClass());
                this.will(8.returnValue((Object)JsonValueEncoderTest_asAdapter.this.mockObjectSpec));
            }
        });
        ManagedObject adapter = this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
        Assert.assertSame((Object)this.mockObjectSpec, (Object)adapter.getSpecification());
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenObjectSpecIsBigDecimalButReprIsNot() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(BigDecimal.class);
        this.representation = JsonRepresentation.newMap((String[])new String[]{"foo", "bar"});
        this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
    }

    @Test
    public void whenReprIsString() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.mockEncodableFacet);
        this.allowingObjectSpecCorrespondingClassAndSpecIdIs(String.class);
        this.representation = new JsonRepresentation((JsonNode)TextNode.valueOf((String)"aString"));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SpecificationLoader)this.oneOf(JsonValueEncoderTest_asAdapter.this.specLoader)).loadSpecification(String.class);
                this.will(9.returnValue((Object)JsonValueEncoderTest_asAdapter.this.mockObjectSpec));
            }
        });
        ManagedObject adapter = this.jsonValueEncoder.asAdapter(this.mockObjectSpec, this.representation, null);
        Assert.assertSame((Object)this.mockObjectSpec, (Object)adapter.getSpecification());
    }

    private <T extends Facet> void allowingObjectSpecHas(final Class<T> facetClass, final T encodableFacet) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectSpecification)this.allowing(JsonValueEncoderTest_asAdapter.this.mockObjectSpec)).getFacet(facetClass);
                this.will(10.returnValue((Object)encodableFacet));
            }
        });
    }

    private void allowingObjectSpecCorrespondingClassAndSpecIdIs(final Class<?> result) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectSpecification)this.allowing(JsonValueEncoderTest_asAdapter.this.mockObjectSpec)).getCorrespondingClass();
                this.will(11.returnValue((Object)result));
                ((ObjectSpecification)this.allowing(JsonValueEncoderTest_asAdapter.this.mockObjectSpec)).getSpecId();
                this.will(11.returnValue((Object)ObjectSpecId.of((String)result.getName())));
            }
        });
    }
}

