/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.isis.core.internaltestsupport.jmocking.JUnitRuleMockery2;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.auto.Mock;
import org.jmock.internal.ExpectationBuilder;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class JsonValueEncoderTest_appendValueAndFormat {
    @Rule
    public JUnitRuleMockery2 context = JUnitRuleMockery2.createFor((JUnitRuleMockery2.Mode)JUnitRuleMockery2.Mode.INTERFACES_AND_CLASSES);
    @Mock
    private ObjectSpecification mockObjectSpec;
    @Mock
    private EncodableFacet mockEncodableFacet;
    @Mock
    private ManagedObject mockObjectAdapter;
    @Mock
    private SpecificationLoader specLoader;
    private JsonRepresentation representation;
    private JsonValueEncoder jsonValueEncoder;

    @Before
    public void setUp() {
        this.jsonValueEncoder = JsonValueEncoder.forTesting((SpecificationLoader)this.specLoader);
        this.representation = JsonRepresentation.newMap((String[])new String[0]);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void whenString() {
        this.allowingObjectSpecToReturnSpecIdFor(String.class);
        this.allowingObjectAdapterToReturn("aString");
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("value"), (Matcher)Matchers.is((Object)"aString"));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"string"));
    }

    @Test
    public void whenBooleanWrapper() {
        this.allowingObjectSpecToReturnSpecIdFor(Boolean.class);
        this.allowingObjectAdapterToReturn(Boolean.TRUE);
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isBoolean("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getBoolean("value"), (Matcher)Matchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void whenBooleanPrimitive() {
        this.allowingObjectSpecToReturnSpecIdFor(Boolean.TYPE);
        this.allowingObjectAdapterToReturn(true);
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isBoolean("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getBoolean("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void whenByteWrapper() {
        this.allowingObjectSpecToReturnSpecIdFor(Byte.class);
        this.allowingObjectAdapterToReturn((byte)123);
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getByte("value"), (Matcher)Matchers.is((Object)123));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"byte"));
    }

    @Test
    public void whenBytePrimitive() {
        this.allowingObjectSpecToReturnSpecIdFor(Byte.TYPE);
        this.allowingObjectAdapterToReturn((byte)123);
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getByte("value"), (Matcher)Matchers.is((Object)123));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"byte"));
    }

    @Test
    public void whenShortWrapper() {
        this.allowingObjectSpecToReturnSpecIdFor(Short.class);
        this.allowingObjectAdapterToReturn((short)12345);
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getShort("value"), (Matcher)Matchers.is((Object)12345));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"short"));
    }

    @Test
    public void whenShortPrimitive() {
        this.allowingObjectSpecToReturnSpecIdFor(Short.TYPE);
        this.allowingObjectAdapterToReturn((short)12345);
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getShort("value"), (Matcher)Matchers.is((Object)12345));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"short"));
    }

    @Test
    public void whenIntWrapper() {
        this.allowingObjectSpecToReturnSpecIdFor(Integer.class);
        this.allowingObjectAdapterToReturn(12345678);
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getInt("value"), (Matcher)Matchers.is((Object)12345678));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"int"));
    }

    @Test
    public void whenIntPrimitive() {
        this.allowingObjectSpecToReturnSpecIdFor(Integer.TYPE);
        this.allowingObjectAdapterToReturn(12345678);
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getInt("value"), (Matcher)Matchers.is((Object)12345678));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"int"));
    }

    @Test
    public void whenLongWrapper() {
        this.allowingObjectSpecToReturnSpecIdFor(Long.class);
        this.allowingObjectAdapterToReturn(12345678901234L);
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getLong("value"), (Matcher)Matchers.is((Object)12345678901234L));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"long"));
    }

    @Test
    public void whenLongPrimitive() {
        this.allowingObjectSpecToReturnSpecIdFor(Long.TYPE);
        this.allowingObjectAdapterToReturn(12345678901234L);
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getLong("value"), (Matcher)Matchers.is((Object)12345678901234L));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"long"));
    }

    @Test
    public void whenFloatWrapper() {
        this.allowingObjectSpecToReturnSpecIdFor(Float.class);
        this.allowingObjectAdapterToReturn(Float.valueOf(123.45f));
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isDecimal("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getFloat("value"), (Matcher)Matchers.is((Object)Float.valueOf(123.45f)));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"decimal"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"float"));
    }

    @Test
    public void whenFloatPrimitive() {
        this.allowingObjectSpecToReturnSpecIdFor(Float.class);
        this.allowingObjectAdapterToReturn(Float.valueOf(123.45f));
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isDecimal("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getFloat("value"), (Matcher)Matchers.is((Object)Float.valueOf(123.45f)));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"decimal"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"float"));
    }

    @Test
    public void whenDoubleWrapper() {
        this.allowingObjectSpecToReturnSpecIdFor(Double.class);
        this.allowingObjectAdapterToReturn(12345.6789);
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isDecimal("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getDouble("value"), (Matcher)Matchers.is((Object)12345.6789));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"decimal"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"double"));
    }

    @Test
    public void whenDoublePrimitive() {
        this.allowingObjectSpecToReturnSpecIdFor(Double.TYPE);
        this.allowingObjectAdapterToReturn(12345.6789);
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isDecimal("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getDouble("value"), (Matcher)Matchers.is((Object)12345.6789));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"decimal"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"double"));
    }

    @Test
    public void whenCharWrapper() {
        this.allowingObjectSpecToReturnSpecIdFor(Character.class);
        this.allowingObjectAdapterToReturn(Character.valueOf('a'));
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getChar("value"), (Matcher)Matchers.is((Object)Character.valueOf('a')));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"char"));
    }

    @Test
    public void whenCharPrimitive() {
        this.allowingObjectSpecToReturnSpecIdFor(Character.TYPE);
        this.allowingObjectAdapterToReturn(Character.valueOf('a'));
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getChar("value"), (Matcher)Matchers.is((Object)Character.valueOf('a')));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"char"));
    }

    @Test
    public void whenJavaUtilDate() {
        this.allowingObjectSpecToReturnSpecIdFor(java.util.Date.class);
        this.allowingObjectAdapterToReturn(JsonValueEncoderTest_appendValueAndFormat.asDateTime("2014-04-25T12:34:45Z"));
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("value"), (Matcher)Matchers.is((Object)"2014-04-25T12:34:45Z"));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"date-time"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"javautildate"));
    }

    @Test
    public void whenJavaSqlDate() {
        this.allowingObjectSpecToReturnSpecIdFor(Date.class);
        this.allowingObjectAdapterToReturn(JsonValueEncoderTest_appendValueAndFormat.asSqlDate("2014-04-25"));
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("value"), (Matcher)Matchers.is((Object)"2014-04-25"));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"date"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"javasqldate"));
    }

    @Test
    public void whenJodaDateTime() {
        this.allowingObjectSpecToReturnSpecIdFor(DateTime.class);
        this.allowingObjectAdapterToReturn(new DateTime((Object)JsonValueEncoderTest_appendValueAndFormat.asDateTime("2014-04-25T12:34:45Z")));
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("value"), (Matcher)Matchers.is((Object)"2014-04-25T12:34:45Z"));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"date-time"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"jodadatetime"));
    }

    @Test
    public void whenJodaLocalDateTime() {
        this.allowingObjectSpecToReturnSpecIdFor(LocalDateTime.class);
        this.allowingObjectAdapterToReturn(new LocalDateTime((Object)JsonValueEncoderTest_appendValueAndFormat.asDateTime("2014-04-25T12:34:45Z")));
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("value"), (Matcher)Matchers.is((Object)"2014-04-25T12:34:45Z"));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"date-time"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"jodalocaldatetime"));
    }

    @Test
    public void whenJodaLocalDate() {
        this.allowingObjectSpecToReturnSpecIdFor(LocalDate.class);
        this.allowingObjectAdapterToReturn(new LocalDate(2014, 4, 25));
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("value"), (Matcher)Matchers.is((Object)"2014-04-25"));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"date"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"jodalocaldate"));
    }

    @Test
    public void whenJavaSqlTimestamp() {
        this.allowingObjectSpecToReturnSpecIdFor(Timestamp.class);
        long time = JsonValueEncoderTest_appendValueAndFormat.asDateTime("2014-04-25T12:34:45Z").getTime();
        this.allowingObjectAdapterToReturn(new Timestamp(time));
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, null, false);
        Assert.assertThat((Object)this.representation.isLong("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getLong("value"), (Matcher)Matchers.is((Object)time));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"utc-millisec"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"javasqltimestamp"));
    }

    @Test
    public void whenBigInteger() {
        this.allowingObjectSpecToReturnSpecIdFor(BigInteger.class);
        this.allowingObjectAdapterToReturn(new BigInteger("12345678901234567890"));
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, "big-integer(22)", false);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.isBigInteger("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getBigInteger("value"), (Matcher)Matchers.is((Object)new BigInteger("12345678901234567890")));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"big-integer(22)"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"javamathbiginteger"));
    }

    @Test
    public void whenBigDecimal() {
        this.allowingObjectSpecToReturnSpecIdFor(BigDecimal.class);
        this.allowingObjectAdapterToReturn(new BigDecimal("12345678901234567890.1234"));
        this.jsonValueEncoder.appendValueAndFormat(this.mockObjectAdapter, this.mockObjectSpec, this.representation, "big-decimal(27,4)", false);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.isBigDecimal("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getBigDecimal("value"), (Matcher)Matchers.is((Object)new BigDecimal("12345678901234567890.1234")));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"big-decimal(27,4)"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"javamathbigdecimal"));
    }

    private void allowingObjectSpecToReturnSpecIdFor(final Class<?> cls) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectSpecification)this.oneOf(JsonValueEncoderTest_appendValueAndFormat.this.mockObjectSpec)).getSpecId();
                this.will(1.returnValue((Object)ObjectSpecId.of((String)cls.getName())));
                ((ObjectSpecification)this.allowing(JsonValueEncoderTest_appendValueAndFormat.this.mockObjectSpec)).getFacet(EncodableFacet.class);
                this.will(1.returnValue(null));
            }
        });
    }

    private void allowingObjectAdapterToReturn(final Object pojo) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ManagedObject)this.oneOf(JsonValueEncoderTest_appendValueAndFormat.this.mockObjectAdapter)).getPojo();
                this.will(2.returnValue((Object)pojo));
                ((ManagedObject)this.allowing(JsonValueEncoderTest_appendValueAndFormat.this.mockObjectAdapter)).getSpecification();
                this.will(2.returnValue((Object)JsonValueEncoderTest_appendValueAndFormat.this.mockObjectSpec));
            }
        });
    }

    private static Date asSqlDate(String text) {
        return new Date(JsonRepresentation.yyyyMMdd.parseDateTime(text).getMillis());
    }

    private static java.util.Date asDateTime(String text) {
        return new java.util.Date(JsonRepresentation.yyyyMMddTHHmmssZ.parseDateTime(text).getMillis());
    }
}

