/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.jaxrsresteasy4.webmodule;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.apache.isis.applib.services.inject.ServiceInjector;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.config.RestEasyConfiguration;
import org.apache.isis.core.webapp.modules.WebModuleAbstract;
import org.apache.isis.core.webapp.modules.WebModuleContext;
import org.apache.isis.viewer.restfulobjects.viewer.webmodule.IsisRestfulObjectsInteractionFilter;
import org.apache.isis.viewer.restfulobjects.viewer.webmodule.auth.AuthenticationStrategyBasicAuth;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.viewer.ro.WebModuleJaxrsRestEasy4")
@Priority(value=0x3FFFFFAF)
@Qualifier(value="JaxrsRestEasy4")
public final class WebModuleJaxrsResteasy4
extends WebModuleAbstract {
    private static final String INTERACTION_FILTER_NAME = "IsisRestfulObjectsInteractionFilter";
    private final IsisConfiguration isisConfiguration;
    private final RestEasyConfiguration restEasyConfiguration;
    private final String restfulPath;
    private final String urlPattern;
    private final String name = "JaxrsRestEasy4";

    @Inject
    public WebModuleJaxrsResteasy4(IsisConfiguration isisConfiguration, RestEasyConfiguration restEasyConfiguration, ServiceInjector serviceInjector) {
        super(serviceInjector);
        this.isisConfiguration = isisConfiguration;
        this.restEasyConfiguration = restEasyConfiguration;
        this.restfulPath = this.restEasyConfiguration.getJaxrs().getDefaultPath() + "/";
        this.urlPattern = this.restfulPath + "*";
    }

    public void prepare(WebModuleContext ctx) {
        ResteasyProviderFactory.setInstance((ResteasyProviderFactory)new ResteasyProviderFactoryImpl());
        super.prepare(ctx);
        if (!this.isApplicable(ctx)) {
            return;
        }
        ctx.addProtectedPath(this.urlPattern);
    }

    public Can<ServletContextListener> init(ServletContext ctx) throws ServletException {
        String authenticationStrategyClassName = this.isisConfiguration.getViewer().getRestfulobjects().getAuthentication().getStrategyClassName().orElse(AuthenticationStrategyBasicAuth.class.getName());
        this.registerFilter(ctx, INTERACTION_FILTER_NAME, IsisRestfulObjectsInteractionFilter.class).ifPresent(filterReg -> {
            filterReg.addMappingForUrlPatterns(null, true, new String[]{this.urlPattern});
            filterReg.setInitParameter("authenticationStrategy", authenticationStrategyClassName);
            filterReg.setInitParameter("whenNoSession", "auto");
            filterReg.setInitParameter("passThru", String.join((CharSequence)",", this.restfulPath + "swagger", this.restfulPath + "health"));
        });
        return Can.empty();
    }

    public String getName() {
        return this.name;
    }
}

