/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.isis.testing.unittestsupport.applib.jmocking.JUnitRuleMockery2;
import org.apache.isis.testing.unittestsupport.applib.util.FileUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.jmock.Expectations;
import org.jmock.auto.Mock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Rule;
import org.junit.Test;

public class Files_deleteFileUtils_Test {
    @Rule
    public JUnitRuleMockery2 context = JUnitRuleMockery2.createFor((JUnitRuleMockery2.Mode)JUnitRuleMockery2.Mode.INTERFACES_AND_CLASSES);
    @Mock
    private FileUtils.Deleter deleter;

    @Test
    public void test() throws IOException {
        final File cusIdxFile = new File("xml/objects/CUS.xml").getAbsoluteFile();
        final File cus1File = new File("xml/objects/CUS/1.xml").getAbsoluteFile();
        final File cus2File = new File("xml/objects/CUS/2.xml").getAbsoluteFile();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FileUtils.Deleter)this.oneOf(Files_deleteFileUtils_Test.this.deleter)).deleteFile((File)this.with(Files_deleteFileUtils_Test.equalsFile(cusIdxFile)));
                ((FileUtils.Deleter)this.oneOf(Files_deleteFileUtils_Test.this.deleter)).deleteFile((File)this.with(Files_deleteFileUtils_Test.equalsFile(cus1File)));
                ((FileUtils.Deleter)this.oneOf(Files_deleteFileUtils_Test.this.deleter)).deleteFile((File)this.with(Files_deleteFileUtils_Test.equalsFile(cus2File)));
            }
        });
        FileUtils.deleteFiles((File)new File("xml/objects").getAbsoluteFile(), (FilenameFilter)FileUtils.filterFileNameExtension((String)".xml"), (FileUtils.Recursion)FileUtils.Recursion.DO_RECURSE, (FileUtils.Deleter)this.deleter);
    }

    private static Matcher<File> equalsFile(File file) throws IOException {
        final String canonicalPath = file.getCanonicalPath();
        return new TypeSafeMatcher<File>(){

            public void describeTo(Description arg0) {
                arg0.appendText("file '" + canonicalPath + "'");
            }

            public boolean matchesSafely(File arg0) {
                try {
                    return arg0.getCanonicalPath().equals(canonicalPath);
                }
                catch (IOException e) {
                    return false;
                }
            }
        };
    }
}

