/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.dom.pojo;

import org.apache.isis.testing.unittestsupport.applib.dom.pojo.PojoTester;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.BooleanHolder;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.ByteHolder;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.DoubleHolder;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.FloatHolder;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.IntHolder;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.LongHolder;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.ShortHolder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class PojoTester_datatypes_primitive_Test {
    @Test
    public void exercise_byte() {
        ByteHolder holder = new ByteHolder();
        Assertions.assertThat((Object)holder).extracting(ByteHolder::getSomeByte).isEqualTo((Object)0);
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(ByteHolder::getSomeByte).isNotEqualTo((Object)0);
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_byte_broken() {
        ByteHolder holder = (ByteHolder)new ByteHolder().butBroken();
        Assertions.assertThat((Object)holder).extracting(ByteHolder::getSomeByte).isEqualTo((Object)0);
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }

    @Test
    public void exercise_short() {
        ShortHolder holder = new ShortHolder();
        Assertions.assertThat((Object)holder).extracting(ShortHolder::getSomeShort).isEqualTo((Object)0);
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(ShortHolder::getSomeShort).isNotEqualTo((Object)0);
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_short_broken() {
        ShortHolder holder = (ShortHolder)new ShortHolder().butBroken();
        Assertions.assertThat((Object)holder).extracting(ShortHolder::getSomeShort).isEqualTo((Object)0);
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }

    @Test
    public void exercise_int() {
        IntHolder holder = new IntHolder();
        Assertions.assertThat((Object)holder).extracting(IntHolder::getSomeInt).isEqualTo((Object)0);
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(IntHolder::getSomeInt).isNotEqualTo((Object)0);
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_int_broken() {
        IntHolder holder = (IntHolder)new IntHolder().butBroken();
        Assertions.assertThat((Object)holder).extracting(IntHolder::getSomeInt).isEqualTo((Object)0);
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }

    @Test
    public void exercise_long() {
        LongHolder holder = new LongHolder();
        Assertions.assertThat((Object)holder).extracting(LongHolder::getSomeLong).isEqualTo((Object)0L);
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(LongHolder::getSomeLong).isNotEqualTo((Object)0L);
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_long_broken() {
        LongHolder holder = (LongHolder)new LongHolder().butBroken();
        Assertions.assertThat((Object)holder).extracting(LongHolder::getSomeLong).isEqualTo((Object)0L);
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }

    @Test
    public void exercise_float() {
        FloatHolder holder = new FloatHolder();
        Assertions.assertThat((Object)holder).extracting(FloatHolder::getSomeFloat).isEqualTo((Object)Float.valueOf(0.0f));
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(FloatHolder::getSomeFloat).isNotEqualTo((Object)Float.valueOf(0.0f));
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_float_broken() {
        FloatHolder holder = (FloatHolder)new FloatHolder().butBroken();
        Assertions.assertThat((Object)holder).extracting(FloatHolder::getSomeFloat).isEqualTo((Object)Float.valueOf(0.0f));
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }

    @Test
    public void exercise_double() {
        DoubleHolder holder = new DoubleHolder();
        Assertions.assertThat((Object)holder).extracting(DoubleHolder::getSomeDouble).isEqualTo((Object)0.0);
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(DoubleHolder::getSomeDouble).isNotEqualTo((Object)0.0);
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_double_broken() {
        DoubleHolder holder = (DoubleHolder)new DoubleHolder().butBroken();
        Assertions.assertThat((Object)holder).extracting(DoubleHolder::getSomeDouble).isEqualTo((Object)0.0);
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }

    @Test
    public void exercise_boolean() {
        BooleanHolder holder = new BooleanHolder();
        Assertions.assertThat((Object)holder).extracting(BooleanHolder::isSomeBoolean).isEqualTo((Object)false);
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_boolean_broken() {
        BooleanHolder holder = (BooleanHolder)new BooleanHolder().butBroken();
        Assertions.assertThat((Object)holder).extracting(BooleanHolder::isSomeBoolean).isEqualTo((Object)false);
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }
}

