/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import org.apache.isis.commons.internal.base._Strings;

public class InjectUtils {
    public static final Predicate<? super Field> persistentMappedBy = f -> {
        Persistent annotation = f.getAnnotation(Persistent.class);
        return annotation != null && !_Strings.isNullOrEmpty((CharSequence)annotation.mappedBy());
    };

    public static <T> Predicate<Field> withTypeAssignableFrom(Class<T> type) {
        return input -> input != null && input.getType().isAssignableFrom(type);
    }

    public static <T> Predicate<Method> withReturnTypeAssignableFrom(Class<T> type) {
        return input -> input != null && input.getReturnType().isAssignableFrom(type);
    }

    public static Predicate<Method> withParametersAssignableFrom(Class<?> ... types) {
        return input -> {
            Class<?>[] parameterTypes;
            if (input != null && (parameterTypes = input.getParameterTypes()).length == types.length) {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i].isAssignableFrom(types[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    public static Predicate<? super Method> withEntityParameter() {
        return m -> {
            Class<?> parameterType = m.getParameterTypes()[0];
            return parameterType.isAnnotationPresent(PersistenceCapable.class);
        };
    }
}

