/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Objects;
import org.apache.isis.commons.internal.exceptions._Exceptions;

public final class FileUtils {
    public static void deleteFilesWithPrefix(String directoryName, String filePrefix, Recursion recursion) {
        FileUtils.deleteFiles(directoryName, FileUtils.filterFileNamePrefix(filePrefix), recursion);
    }

    public static void deleteFiles(String directoryName, String fileExtension, Recursion recursion) {
        FileUtils.deleteFiles(directoryName, FileUtils.filterFileNameExtension(fileExtension), recursion);
    }

    public static void deleteFiles(File directory, String fileExtension, Recursion recursion) {
        FileUtils.deleteFiles(directory, FileUtils.filterFileNameExtension(fileExtension), recursion);
    }

    public static void deleteFiles(String directoryName, FilenameFilter filter, Recursion recursion) {
        File dir = new File(directoryName);
        FileUtils.deleteFiles(dir, filter, recursion);
    }

    public static void deleteFiles(File directory, FilenameFilter filter, Recursion recursion) {
        FileUtils.deleteFiles(directory, filter, recursion, file -> {
            boolean success = file.delete();
            if (!success) {
                throw _Exceptions.assertionError((String)("could not delete file " + file));
            }
        });
    }

    static void deleteFiles(File directory, FilenameFilter filter, Recursion recursion, Deleter deleter) {
        try {
            for (File file : Objects.requireNonNull(directory.listFiles(filter))) {
                deleter.deleteFile(file);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (recursion == Recursion.DO_RECURSE) {
            try {
                for (File subdir : Objects.requireNonNull(directory.listFiles(FileUtils.filterDirectory()))) {
                    FileUtils.deleteFiles(subdir, filter, recursion, deleter);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public static FilenameFilter and(final FilenameFilter ... filters) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (FilenameFilter filter : filters) {
                    if (filter.accept(dir, name)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static FilenameFilter filterFileNameExtension(String fileExtension) {
        return (directory, fileName) -> fileName.endsWith(fileExtension);
    }

    public static FilenameFilter filterFileNamePrefix(String filePrefix) {
        return (directory, fileName) -> fileName.startsWith(filePrefix);
    }

    public static FileFilter filterDirectory() {
        return File::isDirectory;
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface Deleter {
        public void deleteFile(File var1);
    }

    public static enum Recursion {
        DO_RECURSE,
        DONT_RECURSE;

    }
}

