/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.soap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.testing.unittestsupport.applib.soap.SoapEndpoint;
import org.apache.isis.testing.unittestsupport.applib.soap.SoapEndpointSpec;

public class SoapPublishedEndpoints {
    public static final int INITIAL_PORT_DEFAULT = 54345;
    private static SoapPublishedEndpoints instance;
    private final int initialPort;
    private int port;
    private final Map<Class<?>, SoapEndpoint> soapEndpointByType = _Maps.newLinkedHashMap();

    public static SoapPublishedEndpoints instance() {
        if (instance == null) {
            return new SoapPublishedEndpoints();
        }
        return instance;
    }

    public static SoapPublishedEndpoints instance(int initialPort) {
        if (instance != null && SoapPublishedEndpoints.instance.port != initialPort) {
            SoapPublishedEndpoints.dispose();
        }
        if (instance == null) {
            instance = new SoapPublishedEndpoints(initialPort);
        }
        return instance;
    }

    public static void dispose() {
        instance = null;
    }

    SoapPublishedEndpoints() {
        this(54345);
    }

    SoapPublishedEndpoints(int initialPort) {
        this.port = this.initialPort = initialPort;
    }

    public SoapPublishedEndpoints publishIfRequired(Class<?> endpointClass, String endpointAddress) {
        return this.publishIfRequired(new SoapEndpointSpec(endpointClass, endpointAddress));
    }

    public SoapPublishedEndpoints publishIfRequired(Class<?> ... endpointClasses) {
        ArrayList soapEndpointSpecs = _NullSafe.stream((Object[])endpointClasses).map(SoapEndpointSpec::asSoapEndpointSpec).collect(Collectors.toCollection(ArrayList::new));
        return this.publishIfRequired(soapEndpointSpecs);
    }

    public SoapPublishedEndpoints publishIfRequired(List<Class<?>> endpointClasses) {
        ArrayList soapEndpointSpecs = _NullSafe.stream(endpointClasses).map(SoapEndpointSpec::asSoapEndpointSpec).collect(Collectors.toCollection(ArrayList::new));
        return this.publishIfRequired(soapEndpointSpecs);
    }

    public SoapPublishedEndpoints publishIfRequired(SoapEndpointSpec ... soapEndpointSpecs) {
        ArrayList soapEndpointSpecs2 = _NullSafe.stream((Object[])soapEndpointSpecs).collect(Collectors.toCollection(ArrayList::new));
        return instance.publishIfRequired(soapEndpointSpecs2);
    }

    public SoapPublishedEndpoints publishIfRequired(Iterable<SoapEndpointSpec> soapEndpointSpecs) {
        ArrayList soapEndpointSpecs2 = _NullSafe.stream(soapEndpointSpecs).collect(Collectors.toCollection(ArrayList::new));
        return instance.publishEndpointIfRequired(soapEndpointSpecs2);
    }

    public SoapPublishedEndpoints publishEndpointIfRequired(List<SoapEndpointSpec> soapEndpointSpecs) {
        for (SoapEndpointSpec soapEndpointSpec : soapEndpointSpecs) {
            Class<?> endpointClass = soapEndpointSpec.getEndpointClass();
            SoapEndpoint soapEndpoint = this.soapEndpointByType.get(endpointClass);
            if (soapEndpoint != null) continue;
            soapEndpoint = new SoapEndpoint(soapEndpointSpec);
            this.soapEndpointByType.put(endpointClass, soapEndpoint);
            this.port = soapEndpoint.publish(this.port) + 1;
        }
        return this;
    }

    public String getEndpointAddress(Class<?> endpointClass) {
        return this.soapEndpointByType.get(endpointClass).getSpec().getEndpointAddress();
    }

    public <T> T getEndpointImplementor(Class<T> endpointClass) {
        return (T)_Casts.uncheckedCast((Object)this.soapEndpointByType.get(endpointClass).getImplementor());
    }
}

