/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.soap;

import java.util.function.Supplier;

public class SoapEndpointSpec {
    private final Class<?> endpointClass;
    private final Supplier<?> endpointImplementorFactory;
    private String endpointAddress;

    static SoapEndpointSpec asSoapEndpointSpec(Class<?> input) {
        return new SoapEndpointSpec(input);
    }

    public SoapEndpointSpec(Class<?> endpointClass) {
        this(endpointClass, new SupplierUsingDefaultConstructor(endpointClass), null);
    }

    public SoapEndpointSpec(Class<?> endpointClass, String endpointAddress) {
        this(endpointClass, new SupplierUsingDefaultConstructor(endpointClass), endpointAddress);
    }

    public SoapEndpointSpec(Class<?> endpointClass, Supplier<?> endpointImplementorFactory) {
        this(endpointClass, endpointImplementorFactory, null);
    }

    public SoapEndpointSpec(Class<?> endpointClass, Supplier<?> endpointImplementorFactory, String endpointAddress) {
        this.endpointClass = endpointClass;
        this.endpointAddress = endpointAddress;
        this.endpointImplementorFactory = endpointImplementorFactory;
    }

    Class<?> getEndpointClass() {
        return this.endpointClass;
    }

    Supplier<?> getEndpointImplementorFactory() {
        return this.endpointImplementorFactory;
    }

    String getEndpointAddress() {
        return this.endpointAddress;
    }

    void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    private static class SupplierUsingDefaultConstructor
    implements Supplier<Object> {
        private final Class<?> endpointClass;

        public SupplierUsingDefaultConstructor(Class<?> endpointClass) {
            this.endpointClass = endpointClass;
        }

        @Override
        public Object get() {
            try {
                return this.endpointClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

