/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.matchers;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class ClassMatchers {
    private ClassMatchers() {
    }

    public static <T> Matcher<T> anInstanceOf(final Class<T> expected) {
        return new TypeSafeMatcher<T>(){

            public boolean matchesSafely(T actual) {
                return expected.isAssignableFrom(actual.getClass());
            }

            public void describeTo(Description description) {
                description.appendText("an instance of ").appendValue((Object)expected);
            }
        };
    }

    public static Matcher<Class<?>> classEqualTo(Class<?> operand) {
        class ClassEqualsMatcher
        extends TypeSafeMatcher<Class<?>> {
            private final Class<?> clazz;

            public ClassEqualsMatcher(Class<?> clazz) {
                this.clazz = clazz;
            }

            public boolean matchesSafely(Class<?> arg) {
                return this.clazz == arg;
            }

            public void describeTo(Description description) {
                description.appendValue(this.clazz);
            }
        }
        return new ClassEqualsMatcher(operand);
    }

    public static <X> Matcher<Class<X>> anySubclassOf(final Class<X> cls) {
        return new TypeSafeMatcher<Class<X>>(){

            public void describeTo(Description arg0) {
                arg0.appendText("is subclass of ").appendText(cls.getName());
            }

            public boolean matchesSafely(Class<X> item) {
                return cls.isAssignableFrom(item);
            }
        };
    }
}

