/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.jmocking;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Consumer;
import junit.framework.AssertionFailedError;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.reflection._Reflect;
import org.apache.isis.testing.unittestsupport.applib.jmocking.Imposterisers;
import org.apache.isis.testing.unittestsupport.applib.jmocking.MyMockomatic;
import org.jmock.Expectations;
import org.jmock.api.ThreadingPolicy;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.AllDeclaredFields;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.concurrent.Synchroniser;
import org.junit.Assert;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoBuilder;

public class JUnitRuleMockery2
extends JUnit4Mockery
implements MethodRule {
    private final MyMockomatic mockomatic = new MyMockomatic(this);
    private final MutablePicoContainer container = new PicoBuilder().withConstructorInjection().withSetterInjection().build();
    private Class<?> cutType;

    public static JUnitRuleMockery2 createFor(Mode mode) {
        JUnitRuleMockery2 jUnitRuleMockery2 = new JUnitRuleMockery2();
        if (mode == Mode.INTERFACES_AND_CLASSES) {
            jUnitRuleMockery2.setImposteriser(Imposterisers.getDefault());
        }
        jUnitRuleMockery2.setThreadingPolicy((ThreadingPolicy)new Synchroniser());
        return jUnitRuleMockery2;
    }

    private JUnitRuleMockery2() {
    }

    public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                this.prepare(target);
                base.evaluate();
                JUnitRuleMockery2.this.assertIsSatisfied();
            }

            private void prepare(Object target2) throws IllegalAccessException {
                List allFields = AllDeclaredFields.in(target2.getClass());
                this.assertOnlyOneJMockContextIn(allFields);
                List<Object> mocks = this.fillInAutoMocks(target2, allFields);
                Field cutField = this.locateClassUnderTestFieldIfAny(allFields);
                if (cutField != null) {
                    JUnitRuleMockery2.this.cutType = cutField.getType();
                    for (Object mock : mocks) {
                        JUnitRuleMockery2.this.container.addComponent(mock);
                    }
                    JUnitRuleMockery2.this.container.addComponent(JUnitRuleMockery2.this.cutType);
                    Object cut = JUnitRuleMockery2.this.container.getComponent(JUnitRuleMockery2.this.cutType);
                    _Reflect.setFieldOn((Field)cutField, (Object)target2, (Object)cut);
                } else {
                    JUnitRuleMockery2.this.cutType = null;
                }
            }

            private void assertOnlyOneJMockContextIn(List<Field> allFields) {
                Field contextField = null;
                for (Field field : allFields) {
                    if (!JUnitRuleMockery2.class.isAssignableFrom(field.getType())) continue;
                    if (null != contextField) {
                        Assert.fail((String)("Test class should only have one JUnitRuleMockery2 field, found " + contextField.getName() + " and " + field.getName()));
                    }
                    contextField = field;
                }
            }

            protected Field locateClassUnderTestFieldIfAny(List<Field> allFields) {
                Field cutField = null;
                for (Field field : allFields) {
                    if (field.getAnnotation(ClassUnderTest.class) == null) continue;
                    if (null != cutField) {
                        Assert.fail((String)("Test class should only have one field annotated with @ClassUnderTest, found " + cutField.getName() + " and " + field.getName()));
                    }
                    cutField = field;
                }
                return cutField;
            }

            private List<Object> fillInAutoMocks(Object target2, List<Field> allFields) {
                return JUnitRuleMockery2.this.mockomatic.fillIn(target2, allFields);
            }
        };
    }

    public <T> T getClassUnderTest() {
        if (this.cutType == null) {
            throw new IllegalStateException("No field annotated @ClassUnderTest was found");
        }
        return (T)_Casts.uncheckedCast((Object)this.container.getComponent(this.cutType));
    }

    public <T> T ignoring(T mock) {
        this.checking((ExpectationBuilder)JUnitRuleMockery2.expectationsWith(exp -> exp.ignoring(mock)));
        return mock;
    }

    public <T> T allowing(T mock) {
        this.checking((ExpectationBuilder)JUnitRuleMockery2.expectationsWith(exp -> exp.allowing(mock)));
        return mock;
    }

    public <T> T never(T mock) {
        this.checking((ExpectationBuilder)JUnitRuleMockery2.expectationsWith(exp -> exp.never(mock)));
        return mock;
    }

    public void ignoring(Object ... mocks) {
        for (Object mock : mocks) {
            this.ignoring((T)mock);
        }
    }

    public Object oneOf(Object mock) {
        this.checking((ExpectationBuilder)JUnitRuleMockery2.expectationsWith(exp -> exp.oneOf(mock)));
        return mock;
    }

    public <T> T checking(T mock, Class<? extends ExpectationsOn> expectationsClass) {
        try {
            Constructor<? extends ExpectationsOn> constructor = expectationsClass.getConstructor(Object.class);
            ExpectationsOn expectations = constructor.newInstance(mock);
            this.checking((ExpectationBuilder)expectations);
            return mock;
        }
        catch (Exception e) {
            throw new AssertionFailedError("Unable to instantiate expectations class '" + expectationsClass.getName() + "'");
        }
    }

    public static Expectations expectationsWith(Consumer<Expectations> initializer) {
        return new ExpectationsWithInitializer(initializer);
    }

    private static class ExpectationsWithInitializer
    extends Expectations {
        private ExpectationsWithInitializer(Consumer<Expectations> initializer) {
            initializer.accept(this);
        }
    }

    public static class ExpectationsOn
    extends Expectations {
        private final Object mockObj;

        public <T> T mock() {
            return (T)_Casts.uncheckedCast((Object)this.mockObj);
        }

        public ExpectationsOn(Object mockObj) {
            this.mockObj = mockObj;
        }
    }

    public static enum Mode {
        INTERFACES_ONLY,
        INTERFACES_AND_CLASSES;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Checking {
        public Class<? extends ExpectationsOn> value() default ExpectationsOn.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface One {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Never {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Allowing {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Ignoring {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ClassUnderTest {
    }
}

