/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.dom.comparable;

import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class ComparableContractTester<T extends Comparable<T>> {
    private final List<List<T>> orderedTuples;

    public ComparableContractTester(List<List<T>> orderedTuples) {
        this.orderedTuples = orderedTuples;
    }

    public void test() {
        for (List<T> orderedTuple : this.orderedTuples) {
            Comparable item1 = (Comparable)orderedTuple.get(0);
            Comparable item2 = (Comparable)orderedTuple.get(1);
            Comparable item3 = (Comparable)orderedTuple.get(2);
            Comparable item4 = (Comparable)orderedTuple.get(3);
            MatcherAssert.assertThat((String)ComparableContractTester.desc(item1, "<", item2), (Object)item1.compareTo(item2), (Matcher)CoreMatchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
            MatcherAssert.assertThat((String)ComparableContractTester.desc(item2, ">", item1), (Object)item2.compareTo(item1), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
            MatcherAssert.assertThat((String)ComparableContractTester.desc(item2, "==", item3), (Object)item2.compareTo(item3), (Matcher)CoreMatchers.is((Object)0));
            MatcherAssert.assertThat((String)ComparableContractTester.desc(item3, "==", item2), (Object)item3.compareTo(item2), (Matcher)CoreMatchers.is((Object)0));
            MatcherAssert.assertThat((String)ComparableContractTester.desc(item3, "<", item4), (Object)item3.compareTo(item4), (Matcher)CoreMatchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
            MatcherAssert.assertThat((String)ComparableContractTester.desc(item4, ">", item3), (Object)item4.compareTo(item3), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        }
    }

    protected static String desc(Object item1, String op, Object item2) {
        return ComparableContractTester.nullSafe(item1) + op + ComparableContractTester.nullSafe(item2);
    }

    private static String nullSafe(Object item) {
        return item != null ? item.toString() : "null";
    }

    @SafeVarargs
    public static <E> List<E> listOf(E ... elements) {
        return _Lists.of((Object[])elements);
    }
}

