/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.jmocking;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.reflection._Reflect;
import org.apache.isis.testing.unittestsupport.applib.jmocking.Imposterisers;
import org.jmock.Expectations;
import org.jmock.api.Imposteriser;
import org.jmock.api.Invocation;
import org.jmock.api.Invokable;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.action.VoidAction;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class ImposteriserTestUsingCodegenPlugin_Test {
    private Imposteriser imposteriser = Imposterisers.getDefault();
    private Invokable invokable;
    private Invocation invocation;

    ImposteriserTestUsingCodegenPlugin_Test() {
    }

    @BeforeEach
    void setUp() throws Exception {
        _Context.clear();
        this.invokable = new Invokable(){

            public Object invoke(Invocation invocation) throws Throwable {
                ImposteriserTestUsingCodegenPlugin_Test.this.invocation = invocation;
                return "result";
            }
        };
    }

    @AfterEach
    void tearDown() throws Exception {
        this.invokable = null;
        this.invocation = null;
    }

    @Test
    void happyCaseWhenJdkInterface() {
        Assertions.assertTrue((boolean)this.imposteriser.canImposterise(Runnable.class));
        Runnable imposter = (Runnable)this.imposteriser.imposterise(this.invokable, Runnable.class, new Class[0]);
        Assertions.assertNotNull((Object)imposter);
        imposter.run();
    }

    @Test
    @Disabled(value="fails with surefire on jdk-11, not with eclipse")
    void happyCaseWhenJdkClass() {
        Assertions.assertTrue((boolean)this.imposteriser.canImposterise(Date.class));
        Date imposter = (Date)this.imposteriser.imposterise(this.invokable, Date.class, new Class[0]);
        Assertions.assertNotNull((Object)imposter);
        imposter.toString();
    }

    @Test
    void imposteriserShouldBeUsableForMockery() {
        JUnit4Mockery context = new JUnit4Mockery(){
            {
                this.setImposteriser(ImposteriserTestUsingCodegenPlugin_Test.this.imposteriser);
            }
        };
        final NonPublicMethodStub mocked = (NonPublicMethodStub)context.mock(NonPublicMethodStub.class);
        context.checking((ExpectationBuilder)new Expectations(){
            {
                ((NonPublicMethodStub)this.allowing(mocked)).getInteger();
                this.will(3.returnValue((Object)2));
            }
        });
        Assertions.assertNotNull((Object)mocked);
        Assertions.assertNotNull((Object)mocked.getInteger());
        Assertions.assertEquals((int)2, (int)mocked.getInteger());
    }

    @Test
    void cannotImposterisePrimitiveType() {
        Assertions.assertFalse((boolean)this.imposteriser.canImposterise(Integer.TYPE));
    }

    @Test
    void cannotImposteriseVoidType() {
        Assertions.assertFalse((boolean)this.imposteriser.canImposterise(Void.TYPE));
    }

    @Test
    void happyCaseWhenAbstractClass() {
        Assertions.assertTrue((boolean)this.imposteriser.canImposterise(AnAbstractNestedClass.class));
        AnAbstractNestedClass imposter = (AnAbstractNestedClass)this.imposteriser.imposterise(this.invokable, AnAbstractNestedClass.class, new Class[0]);
        Assertions.assertNotNull((Object)imposter);
        Assertions.assertEquals((Object)"result", (Object)imposter.foo());
    }

    @Test
    void happyCaseWhenNonFinalInstantiableClass() {
        Assertions.assertTrue((boolean)this.imposteriser.canImposterise(AnInnerClass.class));
        AnInnerClass imposter = (AnInnerClass)this.imposteriser.imposterise(this.invokable, AnInnerClass.class, new Class[0]);
        Assertions.assertNotNull((Object)imposter);
        Assertions.assertEquals((Object)"result", (Object)imposter.foo());
    }

    @Test
    void cannotImposteriseWhenFinalInstantiableClasses() {
        Assertions.assertFalse((boolean)this.imposteriser.canImposterise(AFinalClass.class));
    }

    @Test
    void happyCaseWhenClassWithNonPublicConstructor() {
        Assertions.assertTrue((boolean)this.imposteriser.canImposterise(AClassWithAPrivateConstructor.class));
        AClassWithAPrivateConstructor imposter = (AClassWithAPrivateConstructor)this.imposteriser.imposterise(this.invokable, AClassWithAPrivateConstructor.class, new Class[0]);
        Assertions.assertNotNull((Object)imposter);
        Assertions.assertEquals((Object)"result", (Object)imposter.foo());
    }

    @Test
    void happyCaseWhenConcreteClassWithConstructorAndInitialisersThatShouldNotBeCalled() {
        Assertions.assertTrue((boolean)this.imposteriser.canImposterise(ConcreteClassWithConstructorAndInstanceInitializer.class));
        ConcreteClassWithConstructorAndInstanceInitializer imposter = (ConcreteClassWithConstructorAndInstanceInitializer)this.imposteriser.imposterise(this.invokable, ConcreteClassWithConstructorAndInstanceInitializer.class, new Class[0]);
        Assertions.assertNotNull((Object)imposter);
        Assertions.assertEquals((Object)"result", (Object)imposter.foo());
    }

    @Test
    void happyCaseWhenCustomInterface() {
        Assertions.assertTrue((boolean)this.imposteriser.canImposterise(AnInterface.class));
        AnInterface imposter = (AnInterface)this.imposteriser.imposterise(this.invokable, AnInterface.class, new Class[0]);
        Assertions.assertNotNull((Object)imposter);
        Assertions.assertEquals((Object)"result", (Object)imposter.foo());
    }

    @Test
    void happyCaseWhenClassInASignedJarFile() throws Exception {
        File jarFile = new File("src/test/resources/signed.jar").getAbsoluteFile();
        Assertions.assertTrue((boolean)jarFile.exists());
        URL jarURL = jarFile.toURI().toURL();
        try (URLClassLoader loader = new URLClassLoader(new URL[]{jarURL});){
            Class<?> typeInSignedJar = loader.loadClass("TypeInSignedJar");
            Assertions.assertTrue((boolean)this.imposteriser.canImposterise(typeInSignedJar));
            Object o = this.imposteriser.imposterise((Invokable)new VoidAction(), typeInSignedJar, new Class[0]);
            Assertions.assertTrue((boolean)typeInSignedJar.isInstance(o));
        }
    }

    @Test
    void cannotImposteriseAClassWithAFinalToStringMethod() {
        Assertions.assertFalse((boolean)this.imposteriser.canImposterise(ClassWithFinalToStringMethod.class));
        try {
            this.imposteriser.imposterise((Invokable)new VoidAction(), ClassWithFinalToStringMethod.class, new Class[0]);
            Assertions.fail((String)"should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @Disabled(value="fails with surefire on jdk-11, not with eclipse")
    void worksAroundBugInCglibWhenAskedToImposteriseObject() {
        this.imposteriser.imposterise((Invokable)new VoidAction(), Object.class, new Class[0]);
        this.imposteriser.imposterise((Invokable)new VoidAction(), Object.class, new Class[]{EmptyInterface.class});
        this.imposteriser.imposterise((Invokable)new VoidAction(), Object.class, new Class[]{AnInterface2.class});
    }

    @Test
    @Disabled(value="fails with surefire on jdk-11, not with eclipse")
    void doesntDelegateFinalizeMethod() throws Exception {
        Invokable failIfInvokedAction = new Invokable(){

            public Object invoke(Invocation invocation) throws Throwable {
                Assertions.fail((String)"invocation should not have happened");
                return null;
            }
        };
        Object imposter = this.imposteriser.imposterise(failIfInvokedAction, Object.class, new Class[0]);
        _Reflect.invokeMethodOn((Method)Object.class.getDeclaredMethod("finalize", new Class[0]), (Object)imposter, (Object[])new Object[0]);
    }

    public static interface AnInterface2 {
        public String foo();
    }

    public static interface EmptyInterface {
    }

    public static class ClassWithFinalToStringMethod {
        public final String toString() {
            return "you can't override me!";
        }
    }

    public static interface AnInterface {
        public String foo();
    }

    public static class ConcreteClassWithConstructorAndInstanceInitializer {
        public ConcreteClassWithConstructorAndInstanceInitializer() {
            ConcreteClassWithConstructorAndInstanceInitializer.shouldNotBeCalled("instance initializer");
            ConcreteClassWithConstructorAndInstanceInitializer.shouldNotBeCalled("constructor");
        }

        public String foo() {
            ConcreteClassWithConstructorAndInstanceInitializer.shouldNotBeCalled("method foo()");
            return null;
        }

        private static void shouldNotBeCalled(String exceptionMessageIfCalled) {
            throw new IllegalStateException(exceptionMessageIfCalled + " should not be called");
        }
    }

    public static class AClassWithAPrivateConstructor {
        private AClassWithAPrivateConstructor(String someArgument) {
        }

        public String foo() {
            return "original result";
        }
    }

    public static final class AFinalClass {
        public String foo() {
            return "original result";
        }
    }

    public static class AnInnerClass {
        public String foo() {
            return "original result";
        }
    }

    public static abstract class AnAbstractNestedClass {
        public abstract String foo();
    }

    static class NonPublicMethodStub {
        NonPublicMethodStub() {
        }

        Integer getInteger() {
            return 1;
        }
    }
}

