/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.dom.pojo;

import org.apache.isis.testing.unittestsupport.applib.dom.pojo.PojoTester;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.JodaLocalDateHolder;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.JodaLocalDateTimeHolder;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.JodaLocalTimeHolder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class PojoTester_datatypes_joda_Test {
    @Test
    public void exercise_local_date() {
        JodaLocalDateHolder holder = new JodaLocalDateHolder();
        Assertions.assertThat((Object)holder).extracting(JodaLocalDateHolder::getSomeLocalDate).isNull();
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(JodaLocalDateHolder::getSomeLocalDate).isNotNull();
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_local_date_broken() {
        JodaLocalDateHolder holder = (JodaLocalDateHolder)new JodaLocalDateHolder().butBroken();
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }

    @Test
    public void exercise_local_date_time() {
        JodaLocalDateTimeHolder holder = new JodaLocalDateTimeHolder();
        Assertions.assertThat((Object)holder).extracting(JodaLocalDateTimeHolder::getSomeLocalDateTime).isNull();
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(JodaLocalDateTimeHolder::getSomeLocalDateTime).isNotNull();
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_local_date_time_broken() {
        JodaLocalDateTimeHolder holder = (JodaLocalDateTimeHolder)new JodaLocalDateTimeHolder().butBroken();
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }

    @Test
    public void exercise_local_time() {
        JodaLocalTimeHolder holder = new JodaLocalTimeHolder();
        Assertions.assertThat((Object)holder).extracting(JodaLocalTimeHolder::getLocalTime).isNull();
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(JodaLocalTimeHolder::getLocalTime).isNotNull();
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_local_time_broken() {
        JodaLocalTimeHolder holder = (JodaLocalTimeHolder)new JodaLocalTimeHolder().butBroken();
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }
}

