/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.dom.pojo;

import org.apache.isis.testing.unittestsupport.applib.dom.pojo.PojoTester;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.JavaLocalDateHolder;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.JavaLocalDateTimeHolder;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.JavaLocalTimeHolder;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.JavaOffsetDateTimeHolder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class PojoTester_datatypes_java_time_Test {
    @Test
    public void exercise_offset_date_time() {
        JavaOffsetDateTimeHolder holder = new JavaOffsetDateTimeHolder();
        Assertions.assertThat((Object)holder).extracting(JavaOffsetDateTimeHolder::getOffsetDateTime).isNull();
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(JavaOffsetDateTimeHolder::getOffsetDateTime).isNotNull();
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_offset_local_date_time_broken() {
        JavaOffsetDateTimeHolder holder = (JavaOffsetDateTimeHolder)new JavaOffsetDateTimeHolder().butBroken();
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }

    @Test
    public void exercise_local_date() {
        JavaLocalDateHolder holder = new JavaLocalDateHolder();
        Assertions.assertThat((Object)holder).extracting(JavaLocalDateHolder::getSomeLocalDate).isNull();
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(JavaLocalDateHolder::getSomeLocalDate).isNotNull();
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_local_date_broken() {
        JavaLocalDateHolder holder = (JavaLocalDateHolder)new JavaLocalDateHolder().butBroken();
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }

    @Test
    public void exercise_local_date_time() {
        JavaLocalDateTimeHolder holder = new JavaLocalDateTimeHolder();
        Assertions.assertThat((Object)holder).extracting(JavaLocalDateTimeHolder::getSomeLocalDateTime).isNull();
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(JavaLocalDateTimeHolder::getSomeLocalDateTime).isNotNull();
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_local_date_time_broken() {
        JavaLocalDateTimeHolder holder = (JavaLocalDateTimeHolder)new JavaLocalDateTimeHolder().butBroken();
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }

    @Test
    public void exercise_local_time() {
        JavaLocalTimeHolder holder = new JavaLocalTimeHolder();
        Assertions.assertThat((Object)holder).extracting(JavaLocalTimeHolder::getLocalTime).isNull();
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(JavaLocalTimeHolder::getLocalTime).isNotNull();
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_local_time_broken() {
        JavaLocalTimeHolder holder = (JavaLocalTimeHolder)new JavaLocalTimeHolder().butBroken();
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }
}

