/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.dom.pojo;

import org.apache.isis.testing.unittestsupport.applib.dom.pojo.PojoTester;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.ApplibBlobHolder;
import org.apache.isis.testing.unittestsupport.applib.dom.pojo.holders.ApplibClobHolder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class PojoTester_datatypes_applib_Test {
    @Test
    public void exercise_blob() {
        ApplibBlobHolder holder = new ApplibBlobHolder();
        Assertions.assertThat((Object)holder).extracting(ApplibBlobHolder::getSomeBlob).isNull();
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(ApplibBlobHolder::getSomeBlob).isNotNull();
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_blob_broken() {
        ApplibBlobHolder holder = (ApplibBlobHolder)new ApplibBlobHolder().butBroken();
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }

    @Test
    public void exercise_clob() {
        ApplibClobHolder holder = new ApplibClobHolder();
        Assertions.assertThat((Object)holder).extracting(ApplibClobHolder::getSomeClob).isNull();
        PojoTester.create().exercise((Object)holder);
        Assertions.assertThat((Object)holder).extracting(ApplibClobHolder::getSomeClob).isNotNull();
        Assertions.assertThat((int)holder.getCounter()).isGreaterThan(0);
    }

    @Test
    public void exercise_clob_broken() {
        ApplibClobHolder holder = (ApplibClobHolder)new ApplibClobHolder().butBroken();
        Assertions.assertThatThrownBy(() -> PojoTester.create().exercise((Object)holder)).isInstanceOf(AssertionFailedError.class);
    }
}

