/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.core.streams;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.Callable;

public class NullPrintStream
extends PrintStream {
    public NullPrintStream() {
        super(new NullByteArrayOutputStream());
    }

    public static void suppressingStdout(Runnable r) {
        NullPrintStream.suppressing(r, true, false);
    }

    public static <T> T suppressingStdout(Callable<T> c) throws Exception {
        return NullPrintStream.suppressing(c, true, false);
    }

    public static void suppressingStderr(Runnable r) {
        NullPrintStream.suppressing(r, false, true);
    }

    public static <T> T suppressingStderr(Callable<T> c) throws Exception {
        return NullPrintStream.suppressing(c, false, true);
    }

    public static void suppressing(Runnable r) throws Exception {
        NullPrintStream.suppressing(r, true, true);
    }

    public static <T> T suppressing(Callable<T> c) throws Exception {
        return NullPrintStream.suppressing(c, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void suppressing(Runnable r, boolean suppressStdout, boolean suppressStderr) {
        PrintStream stdout = System.out;
        PrintStream stderr = System.err;
        try {
            if (suppressStdout) {
                System.setOut(new NullPrintStream());
            }
            if (suppressStderr) {
                System.setErr(new NullPrintStream());
            }
            r.run();
        }
        finally {
            if (suppressStdout) {
                System.setOut(stdout);
            }
            if (suppressStdout) {
                System.setErr(stderr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T suppressing(Callable<T> c, boolean suppressStdout, boolean suppressStderr) throws Exception {
        PrintStream stdout = System.out;
        PrintStream stderr = System.err;
        try {
            if (suppressStdout) {
                System.setOut(new NullPrintStream());
            }
            if (suppressStderr) {
                System.setErr(new NullPrintStream());
            }
            T t = c.call();
            return t;
        }
        finally {
            if (suppressStdout) {
                System.setOut(stdout);
            }
            if (suppressStdout) {
                System.setErr(stderr);
            }
        }
    }

    private static class NullByteArrayOutputStream
    extends ByteArrayOutputStream {
        private NullByteArrayOutputStream() {
        }

        @Override
        public synchronized void write(int b) {
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
        }

        @Override
        public synchronized void writeTo(OutputStream out) throws IOException {
        }
    }
}

