/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.core.soap;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.testing.unittestsupport.applib.core.soap.PublishedEndpoints;
import org.apache.isis.testing.unittestsupport.applib.core.soap.SoapEndpointSpec;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SoapEndpointPublishingRule
implements TestRule {
    static final int INITIAL_PORT = 54345;
    private static PublishedEndpoints publishedEndpoints = new PublishedEndpoints();
    private final List<SoapEndpointSpec> soapEndpointSpecs;

    public SoapEndpointPublishingRule(Class<?> endpointClass, String endpointAddress) {
        this(new SoapEndpointSpec(endpointClass, endpointAddress));
    }

    public SoapEndpointPublishingRule(Class<?> ... endpointClasses) {
        this.soapEndpointSpecs = _NullSafe.stream((Object[])endpointClasses).map(SoapEndpointSpec::asSoapEndpointSpec).collect(Collectors.toCollection(ArrayList::new));
    }

    public SoapEndpointPublishingRule(List<Class<?>> endpointClasses) {
        this.soapEndpointSpecs = _NullSafe.stream(endpointClasses).map(SoapEndpointSpec::asSoapEndpointSpec).collect(Collectors.toCollection(ArrayList::new));
    }

    public SoapEndpointPublishingRule(SoapEndpointSpec ... soapEndpointSpecs) {
        this.soapEndpointSpecs = _NullSafe.stream((Object[])soapEndpointSpecs).collect(Collectors.toCollection(ArrayList::new));
    }

    public SoapEndpointPublishingRule(Iterable<SoapEndpointSpec> soapEndpointSpecs) {
        this.soapEndpointSpecs = _NullSafe.stream(soapEndpointSpecs).collect(Collectors.toCollection(ArrayList::new));
    }

    public Statement apply(Statement base, Description description) {
        publishedEndpoints.publishEndpointIfRequired(this.soapEndpointSpecs);
        return base;
    }

    public String getEndpointAddress(Class<?> endpointClass) {
        return publishedEndpoints.getEndpointAddress(endpointClass);
    }

    public <T> T getEndpointImplementor(Class<T> endpointClass) {
        return publishedEndpoints.getEndpointImplementor(endpointClass);
    }
}

