/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.core.soap;

import java.util.List;
import java.util.Map;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.testing.unittestsupport.applib.core.soap.SoapEndpoint;
import org.apache.isis.testing.unittestsupport.applib.core.soap.SoapEndpointSpec;

class PublishedEndpoints {
    private int port = 54345;
    private Map<Class<?>, SoapEndpoint> soapEndpointByType = _Maps.newLinkedHashMap();

    PublishedEndpoints() {
    }

    void publishEndpointIfRequired(List<SoapEndpointSpec> soapEndpointSpecs) {
        for (SoapEndpointSpec soapEndpointSpec : soapEndpointSpecs) {
            Class<?> endpointClass = soapEndpointSpec.getEndpointClass();
            SoapEndpoint soapEndpoint = this.soapEndpointByType.get(endpointClass);
            if (soapEndpoint != null) continue;
            soapEndpoint = new SoapEndpoint(soapEndpointSpec);
            this.soapEndpointByType.put(endpointClass, soapEndpoint);
            this.port = soapEndpoint.publish(this.port) + 1;
        }
    }

    String getEndpointAddress(Class<?> endpointClass) {
        return this.soapEndpointByType.get(endpointClass).getSpec().getEndpointAddress();
    }

    <T> T getEndpointImplementor(Class<T> endpointClass) {
        return (T)_Casts.uncheckedCast((Object)this.soapEndpointByType.get(endpointClass).getImplementor());
    }
}

