/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.core.jmocking;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.hamcrest.Description;
import org.jmock.api.Action;
import org.jmock.api.Invocation;

public final class JMockActions {
    private JMockActions() {
    }

    @SafeVarargs
    public static <T> Action returnEach(T ... values) {
        return new ReturnEachAction((Object[])values);
    }

    public static Action returnArgument(int i) {
        return new ReturnArgumentJMockAction(i);
    }

    private static final class ReturnArgumentJMockAction
    implements Action {
        private final int i;

        private ReturnArgumentJMockAction(int i) {
            this.i = i;
        }

        public void describeTo(Description description) {
            description.appendText("parameter #" + this.i + " ");
        }

        public Object invoke(Invocation invocation) throws Throwable {
            return invocation.getParameter(this.i);
        }
    }

    private static class ReturnEachAction<T>
    implements Action {
        private final Collection<T> collection;
        private final Iterator<T> iterator;

        ReturnEachAction(Collection<T> collection) {
            this.collection = collection;
            this.iterator = collection.iterator();
        }

        @SafeVarargs
        private ReturnEachAction(T ... array) {
            this((Collection<T>)Arrays.asList(array));
        }

        public T invoke(Invocation invocation) throws Throwable {
            return this.iterator.next();
        }

        public void describeTo(Description description) {
            description.appendValueList("return iterator.next() over ", ", ", "", this.collection);
        }
    }
}

