/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.core.jmocking;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.isis.commons.internal.proxy._ProxyFactory;
import org.apache.isis.commons.internal.proxy._ProxyFactoryService;
import org.apache.isis.core.codegen.bytebuddy.services.ProxyFactoryServiceByteBuddy;
import org.jmock.api.Imposteriser;
import org.jmock.api.Invocation;
import org.jmock.api.Invokable;
import org.jmock.lib.JavaReflectionImposteriser;

class ImposteriserUsingCodegenPlugin
implements Imposteriser {
    public static final Imposteriser INSTANCE = new ImposteriserUsingCodegenPlugin();
    private final Imposteriser reflectionImposteriser = new JavaReflectionImposteriser();

    private ImposteriserUsingCodegenPlugin() {
    }

    public boolean canImposterise(Class<?> mockedType) {
        if (mockedType.isInterface()) {
            return this.reflectionImposteriser.canImposterise(mockedType);
        }
        return !mockedType.isPrimitive() && !Modifier.isFinal(mockedType.getModifiers()) && !ImposteriserUsingCodegenPlugin.toStringMethodIsFinal(mockedType);
    }

    public <T> T imposterise(Invokable mockObject, Class<T> mockedType, Class<?> ... ancilliaryTypes) {
        if (!this.canImposterise(mockedType)) {
            throw new IllegalArgumentException(mockedType.getName() + " cannot be imposterized (either a primitive, or a final type or has final toString method)");
        }
        if (mockedType.isInterface()) {
            return (T)this.reflectionImposteriser.imposterise(mockObject, mockedType, (Class[])ancilliaryTypes);
        }
        _ProxyFactory factory = _ProxyFactory.builder(mockedType).interfaces((Class[])ancilliaryTypes).build((_ProxyFactoryService)new ProxyFactoryServiceByteBuddy());
        boolean initialize = false;
        return (T)factory.createInstance((obj, method, args) -> mockObject.invoke(new Invocation(obj, method, args)), false);
    }

    private static boolean toStringMethodIsFinal(Class<?> type) {
        try {
            Method toString = type.getMethod("toString", new Class[0]);
            return Modifier.isFinal(toString.getModifiers());
        }
        catch (SecurityException e) {
            throw new IllegalStateException("not allowed to reflect on toString method", e);
        }
        catch (NoSuchMethodException e) {
            throw new Error("no public toString method found", e);
        }
    }
}

