/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.core.jaxb;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.resources._Resources;

class JaxbUtil2 {
    private static Map<Class<?>, JAXBContext> jaxbContextByClass = new ConcurrentHashMap();

    private JaxbUtil2() {
    }

    public static <T> T fromXml(Reader reader, Class<T> dtoClass) {
        Unmarshaller un = null;
        try {
            un = JaxbUtil2.jaxbContextFor(dtoClass).createUnmarshaller();
            return (T)_Casts.uncheckedCast((Object)un.unmarshal(reader));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromXml(Class<?> contextClass, String resourceName, Charset charset, Class<T> dtoClass) throws IOException {
        String s = _Resources.loadAsString(contextClass, (String)resourceName, (Charset)charset);
        return JaxbUtil2.fromXml(new StringReader(s), dtoClass);
    }

    public static <T> String toXml(T dto) {
        CharArrayWriter caw = new CharArrayWriter();
        JaxbUtil2.toXml(dto, caw);
        return caw.toString();
    }

    public static <T> void toXml(T dto, Writer writer) {
        Marshaller m = null;
        try {
            Class<?> aClass = dto.getClass();
            m = JaxbUtil2.jaxbContextFor(aClass).createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(dto, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> JAXBContext jaxbContextFor(Class<T> dtoClass) {
        JAXBContext jaxbContext = jaxbContextByClass.get(dtoClass);
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{dtoClass});
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            jaxbContextByClass.put(dtoClass, jaxbContext);
        }
        return jaxbContext;
    }
}

