/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.core.files;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import org.apache.isis.commons.internal.exceptions._Exceptions;

public final class Files {
    public static void deleteFilesWithPrefix(String directoryName, String filePrefix, Recursion recursion) {
        Files.deleteFiles(directoryName, Files.filterFileNamePrefix(filePrefix), recursion);
    }

    public static void deleteFiles(String directoryName, String fileExtension, Recursion recursion) {
        Files.deleteFiles(directoryName, Files.filterFileNameExtension(fileExtension), recursion);
    }

    public static void deleteFiles(File directory, String fileExtension, Recursion recursion) {
        Files.deleteFiles(directory, Files.filterFileNameExtension(fileExtension), recursion);
    }

    public static void deleteFiles(String directoryName, FilenameFilter filter, Recursion recursion) {
        File dir = new File(directoryName);
        Files.deleteFiles(dir, filter, recursion);
    }

    public static void deleteFiles(File directory, FilenameFilter filter, Recursion recursion) {
        Files.deleteFiles(directory, filter, recursion, file -> {
            boolean success = file.delete();
            if (!success) {
                throw _Exceptions.assertionError((String)("could not delete file " + file));
            }
        });
    }

    static void deleteFiles(File directory, FilenameFilter filter, Recursion recursion, Deleter deleter) {
        try {
            for (File file : directory.listFiles(filter)) {
                deleter.deleteFile(file);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (recursion == Recursion.DO_RECURSE) {
            try {
                for (File subdir : directory.listFiles(Files.filterDirectory())) {
                    Files.deleteFiles(subdir, filter, recursion, deleter);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public static FilenameFilter and(final FilenameFilter ... filters) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (FilenameFilter filter : filters) {
                    if (filter.accept(dir, name)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static FilenameFilter filterFileNameExtension(final String fileExtension) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(fileExtension);
            }
        };
    }

    public static FilenameFilter filterFileNamePrefix(final String filePrefix) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.startsWith(filePrefix);
            }
        };
    }

    public static FileFilter filterDirectory() {
        return new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.isDirectory();
            }
        };
    }

    private Files() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface Deleter {
        public void deleteFile(File var1);
    }

    public static enum Recursion {
        DO_RECURSE,
        DONT_RECURSE;

    }
}

