/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.bean;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import org.apache.isis.commons.internal.collections._Lists;

public final class PojoTester {
    private final Map<Class<?>, FixtureDatumFactory<?>> fixtureDataByType = new HashMap();
    private final AtomicInteger counter = new AtomicInteger();
    private Mode mode;

    public static PojoTester strict() {
        return new PojoTester(Mode.STRICT);
    }

    public static PojoTester relaxed() {
        return new PojoTester(Mode.RELAXED);
    }

    private PojoTester(Mode mode) {
        this.mode = mode;
        FixtureDatumFactory<Boolean> booleanDatumFactory = new FixtureDatumFactory<Boolean>(Boolean.class){

            @Override
            public Boolean getNext() {
                return PojoTester.this.counter.getAndIncrement() == 0;
            }
        };
        this.fixtureDataByType.put(Boolean.TYPE, booleanDatumFactory);
        this.fixtureDataByType.put(Boolean.class, booleanDatumFactory);
        FixtureDatumFactory<Byte> byteDatumFactory = new FixtureDatumFactory<Byte>(Byte.class){

            @Override
            public Byte getNext() {
                return (byte)PojoTester.this.counter.getAndIncrement();
            }
        };
        this.fixtureDataByType.put(Byte.TYPE, byteDatumFactory);
        this.fixtureDataByType.put(Byte.class, byteDatumFactory);
        FixtureDatumFactory<Short> shortDatumFactory = new FixtureDatumFactory<Short>(Short.class){

            @Override
            public Short getNext() {
                return (short)PojoTester.this.counter.getAndIncrement();
            }
        };
        this.fixtureDataByType.put(Short.TYPE, shortDatumFactory);
        this.fixtureDataByType.put(Short.class, shortDatumFactory);
        FixtureDatumFactory<Character> charDatumFactory = new FixtureDatumFactory<Character>(Character.class){

            @Override
            public Character getNext() {
                return Character.valueOf((char)PojoTester.this.counter.getAndIncrement());
            }
        };
        this.fixtureDataByType.put(Character.TYPE, charDatumFactory);
        this.fixtureDataByType.put(Character.class, charDatumFactory);
        FixtureDatumFactory<Integer> intDatumFactory = new FixtureDatumFactory<Integer>(Integer.class){

            @Override
            public Integer getNext() {
                return PojoTester.this.counter.getAndIncrement();
            }
        };
        this.fixtureDataByType.put(Integer.TYPE, intDatumFactory);
        this.fixtureDataByType.put(Integer.class, intDatumFactory);
        FixtureDatumFactory<Long> longDatumFactory = new FixtureDatumFactory<Long>(Long.class){

            @Override
            public Long getNext() {
                return PojoTester.this.counter.getAndIncrement();
            }
        };
        this.fixtureDataByType.put(Long.TYPE, longDatumFactory);
        this.fixtureDataByType.put(Long.class, longDatumFactory);
        FixtureDatumFactory<Float> floatDatumFactory = new FixtureDatumFactory<Float>(Float.class){

            @Override
            public Float getNext() {
                return new Float(PojoTester.this.counter.getAndIncrement());
            }
        };
        this.fixtureDataByType.put(Float.TYPE, floatDatumFactory);
        this.fixtureDataByType.put(Float.class, floatDatumFactory);
        FixtureDatumFactory<Double> doubleDatumFactory = new FixtureDatumFactory<Double>(Double.class){

            @Override
            public Double getNext() {
                return new Double(PojoTester.this.counter.getAndIncrement());
            }
        };
        this.fixtureDataByType.put(Double.TYPE, doubleDatumFactory);
        this.fixtureDataByType.put(Double.class, doubleDatumFactory);
        this.fixtureDataByType.put(String.class, new FixtureDatumFactory<String>(String.class){

            @Override
            public String getNext() {
                return "string" + PojoTester.this.counter.getAndIncrement();
            }
        });
        this.fixtureDataByType.put(BigDecimal.class, new FixtureDatumFactory<BigDecimal>(BigDecimal.class){

            @Override
            public BigDecimal getNext() {
                return new BigDecimal(PojoTester.this.counter.getAndIncrement());
            }
        });
        this.fixtureDataByType.put(BigInteger.class, new FixtureDatumFactory<BigInteger>(BigInteger.class){

            @Override
            public BigInteger getNext() {
                return BigInteger.valueOf(PojoTester.this.counter.getAndIncrement());
            }
        });
        this.fixtureDataByType.put(Date.class, new FixtureDatumFactory<Date>(Date.class){

            @Override
            public Date getNext() {
                return new Date(PojoTester.this.counter.getAndIncrement());
            }
        });
        this.fixtureDataByType.put(Timestamp.class, new FixtureDatumFactory<Timestamp>(Timestamp.class){

            @Override
            public Timestamp getNext() {
                return new Timestamp(PojoTester.this.counter.getAndIncrement());
            }
        });
        this.fixtureDataByType.put(Pattern.class, new FixtureDatumFactory<Pattern>(Pattern.class){

            @Override
            public Pattern getNext() {
                return Pattern.compile("p" + PojoTester.this.counter.getAndIncrement());
            }
        });
        this.fixtureDataByType.put(File.class, new FixtureDatumFactory<File>(File.class){

            @Override
            public File getNext() {
                return new File("file" + PojoTester.this.counter.getAndIncrement());
            }
        });
        FixtureDatumFactory listDatumFactory = new FixtureDatumFactory<List<?>>(){

            @Override
            public List<?> getNext() {
                ArrayList<String> list = new ArrayList<String>();
                list.add("element" + PojoTester.this.counter.getAndIncrement());
                list.add("element" + PojoTester.this.counter.getAndIncrement());
                list.add("element" + PojoTester.this.counter.getAndIncrement());
                return list;
            }
        };
        this.fixtureDataByType.put(Iterable.class, listDatumFactory);
        this.fixtureDataByType.put(Collection.class, listDatumFactory);
        this.fixtureDataByType.put(List.class, listDatumFactory);
        this.fixtureDataByType.put(Set.class, new FixtureDatumFactory<Set<?>>(){

            @Override
            public Set<?> getNext() {
                HashSet<String> list = new HashSet<String>();
                list.add("element" + PojoTester.this.counter.getAndIncrement());
                list.add("element" + PojoTester.this.counter.getAndIncrement());
                list.add("element" + PojoTester.this.counter.getAndIncrement());
                return list;
            }
        });
        this.fixtureDataByType.put(SortedSet.class, new FixtureDatumFactory<SortedSet<?>>(){

            @Override
            public SortedSet<?> getNext() {
                TreeSet<String> list = new TreeSet<String>();
                list.add("element" + PojoTester.this.counter.getAndIncrement());
                list.add("element" + PojoTester.this.counter.getAndIncrement());
                list.add("element" + PojoTester.this.counter.getAndIncrement());
                return list;
            }
        });
        this.fixtureDataByType.put(byte[].class, new FixtureDatumFactory<byte[]>(){

            @Override
            public byte[] getNext() {
                return new byte[]{(byte)PojoTester.this.counter.getAndIncrement()};
            }
        });
        this.fixtureDataByType.put(char[].class, new FixtureDatumFactory<char[]>(){

            @Override
            public char[] getNext() {
                return new char[]{(char)PojoTester.this.counter.getAndIncrement()};
            }
        });
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public <T> PojoTester withFixture(Class<T> c, T ... fixtureData) {
        if (Enum.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("No need to provide fixture data for enums");
        }
        if (fixtureData == null || fixtureData.length == 0) {
            throw new IllegalArgumentException("Test data is mandatory");
        }
        return this.withFixture(new FixtureDatumFactory<T>(c, fixtureData));
    }

    public <T> PojoTester withFixture(FixtureDatumFactory<T> factory) {
        this.fixtureDataByType.put(factory.getType(), factory);
        return this;
    }

    public void exercise(Object bean) {
        this.exercise(bean, FilterSet.excluding(new String[0]));
    }

    public void exercise(Object bean, FilterSet filterSet) {
        ArrayList<Method> gettersDone = new ArrayList<Method>();
        ArrayList<TestException> problems = new ArrayList<TestException>();
        Map<String, Method> methods = PojoTester.getMethodsAsMap(bean);
        for (Map.Entry<String, Method> e : methods.entrySet()) {
            String methodName = e.getKey();
            if (!methodName.startsWith("set") || e.getValue().getParameterTypes().length != 1) continue;
            char first = methodName.charAt(3);
            String remainder = methodName.substring(4);
            String property = Character.toLowerCase(first) + remainder;
            if (!filterSet.shouldInclude(property)) continue;
            try {
                this.testOne(bean, methods, property, gettersDone);
            }
            catch (TestException te) {
                problems.add(te);
            }
        }
        PojoTester.handleExceptions(problems);
    }

    private static void handleExceptions(List<TestException> problems) {
        if (!problems.isEmpty()) {
            Throwable lastCause = null;
            StringBuilder b = new StringBuilder();
            String newline = "";
            for (TestException te : problems) {
                b.append(newline).append(te.getMessage());
                newline = "\n";
                if (te.getCause() == null) continue;
                lastCause = te.getCause();
            }
            AssertionFailedError err = new AssertionFailedError(b.toString());
            if (lastCause != null) {
                err.initCause(lastCause);
            }
            throw err;
        }
    }

    private static Map<String, Method> getMethodsAsMap(Object bean) {
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        for (Method m : bean.getClass().getMethods()) {
            methodMap.put(m.getName(), m);
        }
        return methodMap;
    }

    private void testOne(Object bean, Map<String, Method> methods, String property, List<Method> earlierGetters) throws TestException {
        String setterName = this.getAccessor("set", property);
        for (Method setterMethod : methods.values()) {
            Class<?>[] parameterTypes = setterMethod.getParameterTypes();
            if (!setterMethod.getName().equals(setterName) || parameterTypes.length != 1) continue;
            this.exercise(bean, property, methods, setterMethod, parameterTypes[0], earlierGetters);
            return;
        }
        throw new TestException("No matching setter found for " + property + ".");
    }

    private void exercise(Object bean, String property, Map<String, Method> methods, Method setterMethod, Class<?> parameterType, List<Method> earlierGetters) throws AssertionFailedError, TestException {
        String getterName;
        String setterName = setterMethod.getName();
        FixtureDatumFactory<Object> factory = this.fixtureDataByType.get(parameterType);
        if (factory == null) {
            if (Enum.class.isAssignableFrom(parameterType)) {
                final Object[] testData = parameterType.getEnumConstants();
                factory = new FixtureDatumFactory<Object>(Object.class){
                    private int index;
                    {
                        super(type);
                        this.index = testData.length - 1;
                    }

                    @Override
                    public Object getNext() {
                        this.index = (this.index + 1) % testData.length;
                        return testData[this.index];
                    }
                };
                this.fixtureDataByType.put(parameterType, factory);
            } else {
                throw new TestException("No fixture test data is available for " + setterName + "( " + parameterType.getName() + " ).");
            }
        }
        PojoTester.checkMethodVisibility(property, setterName, setterMethod);
        if (parameterType == Boolean.TYPE) {
            getterName = this.getAccessor("is", property);
            if (property.startsWith("Is") && !methods.containsKey(getterName)) {
                getterName = this.getAccessor("is", property.substring(2));
            }
        } else {
            getterName = this.getAccessor("get", property);
        }
        try {
            Method getterMethod = bean.getClass().getMethod(getterName, new Class[0]);
            if (getterMethod.getReturnType().equals(Void.TYPE)) {
                throw new TestException(getterName + "(...) is void return.");
            }
            PojoTester.checkMethodVisibility(property, getterName, getterMethod);
            ArrayList earlierGetterOriginalValues = _Lists.newArrayList();
            for (Method earlierGetter : earlierGetters) {
                Object earlierValue = earlierGetter.invoke(bean, new Object[0]);
                earlierGetterOriginalValues.add(earlierValue);
            }
            Object value = null;
            for (int i = 0; i < 3; ++i) {
                value = factory.getNext();
                PojoTester.invokeSetterAndGetter(bean, property, setterMethod, getterMethod, value);
                int j = 0;
                for (Method earlierGetter : earlierGetters) {
                    Object earlierGetterOriginalValue;
                    Object earlierGetterCurrentValue = earlierGetter.invoke(bean, new Object[0]);
                    if (Objects.equals(earlierGetterOriginalValue = earlierGetterOriginalValues.get(j++), earlierGetterCurrentValue)) continue;
                    throw new TestException(setterName + " interferes with " + earlierGetter.getName());
                }
            }
            earlierGetters.add(getterMethod);
        }
        catch (NoSuchMethodException e) {
            if (this.mode == Mode.RELAXED) {
                return;
            }
            TestException error = new TestException(property + ": " + e.getMessage());
            error.initCause(e);
            throw error;
        }
        catch (Exception e) {
            TestException error = new TestException(property + ": " + e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    private static void checkMethodVisibility(String property, String accessorName, Method method) throws AssertionFailedError, TestException {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new TestException("Test failed for " + property + " because " + accessorName + " is not publicly visible.");
        }
        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            throw new TestException("Test failed for " + property + " because " + accessorName + " is declared in a class that is not publicly visible.");
        }
    }

    private static void invokeSetterAndGetter(Object bean, String property, Method setterMethod, Method getterMethod, Object t) throws IllegalAccessException, InvocationTargetException, AssertionFailedError, TestException {
        setterMethod.invoke(bean, t);
        Object r = getterMethod.invoke(bean, new Object[0]);
        if (!t.getClass().equals(r.getClass())) {
            throw new TestException("Test failed for " + property + " because types do not match.");
        }
        if (!t.equals(r)) {
            throw new TestException("Test failed for " + property + " using " + t.toString());
        }
        if (t instanceof Iterable) {
            Iterator it = ((Iterable)t).iterator();
            Iterator ir = ((Iterable)r).iterator();
            while (it.hasNext() && ir.hasNext()) {
                Object ri;
                Object ti = it.next();
                if (ti.equals(ri = ir.next())) continue;
                throw new TestException("Test failed for " + property + " with iterator item " + ti.toString());
            }
            if (it.hasNext() || ir.hasNext()) {
                throw new TestException("Test failed for " + property + " because iteration lengths differ.");
            }
        }
    }

    private String getAccessor(String prefix, String property) {
        if (property.length() == 1) {
            return prefix + Character.toUpperCase(property.charAt(0));
        }
        return prefix + Character.toUpperCase(property.charAt(0)) + property.substring(1);
    }

    public static class FilterSet
    extends HashSet<String> {
        private static final long serialVersionUID = 1L;
        private boolean include = false;

        private FilterSet(String ... string) {
            super.addAll(Arrays.asList(string));
        }

        private boolean shouldInclude(String x) {
            if (this.include) {
                return this.isEmpty() || this.contains(x);
            }
            return !this.contains(x);
        }

        public static FilterSet includingOnly(String ... property) {
            FilterSet filterSet = new FilterSet(property);
            filterSet.include = true;
            return filterSet;
        }

        public static FilterSet excluding(String ... property) {
            return new FilterSet(property);
        }
    }

    public static final class TestException
    extends Exception {
        private static final long serialVersionUID = 7870820619976334343L;

        public TestException(String message) {
            super(message);
        }

        public TestException(String message, Throwable t) {
            super(message, t);
        }
    }

    private static enum Mode {
        STRICT,
        RELAXED;

    }

    public static class FixtureDatumFactory<T> {
        private Class<T> type;
        private T[] fixtureData;
        private int index;

        public FixtureDatumFactory() {
        }

        public FixtureDatumFactory(Class<T> type) {
            this.type = type;
        }

        @SafeVarargs
        public FixtureDatumFactory(Class<T> type, T ... fixtureData) {
            this(type);
            this.fixtureData = fixtureData;
            this.index = fixtureData.length - 1;
        }

        public Class<T> getType() {
            return this.type;
        }

        public T getNext() {
            this.index = (this.index + 1) % this.fixtureData.length;
            return this.fixtureData[this.index];
        }
    }
}

